import { World, Ob } from "../glsl";
import lilGUI from "lil-gui";
/**
 * [lil-gui](https://github.com/georgealways/lil-gui)の制御を行う{@link Gui}クラスのオブジェクトです。
 *
 * パラメータを変更するGUIの{@link Gui#add 追加}を行いたい場合に使用します。
 *
 * 画面の右上に lilGUI の UI を表示するためには、[config.debug](/reference/interfaces/Config/#デバッグ設定) に true を設定し、[config.addon.lilGUI](/reference/interfaces/Config/#addon) に lilGUI のクラスを設定します。
 *
 * ```js
 * import lilGUI from "lil-gui";
 *
 * const { start } = setup({
 *  addon: { lilGUI },
 *  debug: true
 * });
 * ```
 */
declare let gui: Gui;
/**
 * [lil-gui](https://github.com/georgealways/lil-gui)の制御を行います。
 *
 * このクラスは`negl`内部でインスタンス化され、{@link gui}オブジェクトとして提供されます。
 *
 * **取得方法**
 * ```ts
 * import { gui } from "../negl";
 * // or
 * window.negl.gui
 * ```
 *
 *
 */
declare class Gui {
    #private;
    static init(): Promise<Gui>;
    constructor(lilGUIClass?: typeof lilGUI);
    init(): void;
    /**
     * lil-guiにGUIを追加します。
     *
     * ```js
     * const { gui } = negl
     * gui.add(lilGUI => {
     *   const folder = lilGUI.addFolder('folder-name');
     *   folder.add(someObject, 'value', 0, 1, 0.1);
     * })
     * ```
     *
     * @param {(gui: lilGUI) => void}
     * @returns
     */
    add(callback: (gui: lilGUI) => void): void;
    addRecommendGUI(world: World): void;
    addObDebug(o: Ob): void;
    /**
     * lilGUIインスタンスを破棄します。
     * @returns
     */
    destroy(): void;
    /**
     * lilGUIのインスタンスを取得します。
     * @returns {lilGUI}
     */
    getLilGuiInstance(): lilGUI | undefined;
}
export { gui, Gui };
//# sourceMappingURL=gui.d.ts.map