/**
 * 下層ページ（ponyo.htmlなど）用制御ファイル
 * Control file for subpages (such as ponyo.html)
 *
 * data-page="detail" ページ独自の処理を行います。
 * Performs page-specific processing for data-page="detail".
 */
import { world } from "negl";
import { scrollSnap } from "#/parts/helper/scrollSnap";

import {
  addLoadingAnimation,
  animateDetailSvg,
} from "#/parts/loader-ghibli";

export default async function (transitionState) {
  const goTo = detailScrollSlider(transitionState);

  const sliderO = world.getObByEl(".slider");
  sliderO.goNext = goTo.bind(null, 2);

  addLoadingAnimation(loadAnimation);
}

function detailScrollSlider(transitionState) {
  const sliderO = world.getObByEl(".dc-slider");

  const slideNum = sliderO.slides.length;
  // 初期表示のスライド番号
  // Initial slide number for display
  let activeSlideIdx = Math.round(Math.random() * slideNum);
  if (
    transitionState &&
    transitionState.next.store.get("slideIdx") !== undefined
  ) {
    activeSlideIdx = transitionState.next.store.get("slideIdx");
  }
  sliderO.setTo(activeSlideIdx);

  return scrollSnap(
    (slideIdx) => sliderO.goTo(-slideIdx),
    { speed: 7, damping: 2.5 },
    -activeSlideIdx
  );
}

export function loadAnimation() {
  animateDetailSvg();
}
