import { Ob, viewport, utils } from "negl";
import { BoxGeometry, MeshStandardMaterial, TetrahedronGeometry } from "three";

export default class extends Ob {
  setupVertex() {
    return;
  }
  setupFragment() {
    return;
  }
  setupGeometry() {
    const depth = this.dataAttrs.depth ?? this.rect.width;
    return new BoxGeometry(
      this.rect.width,
      this.rect.height,
      depth,
      1,
      1,
      1
    );
  }
  async resize(duration = 1) {
    this.resizing = true;

    const {
      $: { el },
      mesh,
      originalRect,
    } = this;

    const nextRect = el.getBoundingClientRect();
    const { x, y } = this.getWorldPosition(nextRect, viewport);

    if (mesh === undefined) return;

    const p1 = new Promise((onComplete) => {

      utils.tween(mesh.position, {
        x,
        y,
        duration,
        onComplete,
      })
    });

    // 大きさの変更
    const p2 = new Promise((onComplete) => {
      utils.tween(this.scale, {
        width: nextRect.width / originalRect.width,
        height: nextRect.height / originalRect.height,
        depth: nextRect.width / originalRect.width,
        duration,
        onUpdate: () => {
          mesh.scale.set(this.scale.width, this.scale.height, this.scale.depth);
        },
        onComplete
      })
    });

    await Promise.all([p1, p2]);

    this.rect = nextRect;

    this.resizing = false;
  }
  setupMaterial() {
    return new MeshStandardMaterial;
  }
  debug(folder) {
    folder.addColor(this.material, "color")
    folder.addColor(this.material, "emissive")
  }
  afterInit() {
    this.mesh.position.z = this.dataAttrs.z ?? 0;
  }
}
