import { Ob, viewport } from "negl";
import { Sky } from "three/examples/jsm/objects/Sky";

export default class extends Ob {
  beforeCreateMesh() {
    this.fixed = true;
  }
  setupVertex() {
    return;
  }
  setupFragment() {
    return;
  }
  setupGeometry() {
    return;
  }
  setupMaterial() {
    return;
  }
  resize() {}
  scroll() {}
  setupMesh() {
    const mesh = new Sky();
    this.material = mesh.material;
    this.geometry = mesh.geometry;

    mesh.scale.setScalar(viewport.far);

    const skyUniforms = mesh.material.uniforms;
    skyUniforms["turbidity"].value = 0;
    skyUniforms["rayleigh"].value = 2;
    skyUniforms["mieCoefficient"].value = 0.005;
    skyUniforms["mieDirectionalG"].value = 0.8;
    return mesh;
  }

  debug(folder) {
    const skyUniforms = this.mesh.material.uniforms;
    folder.add(skyUniforms.turbidity, "value", 0, 30, 0.1).name("turbidity").listen();
    folder.add(skyUniforms.rayleigh, "value", 0, 3, 0.1).name("rayleigh").listen();
    folder.add(skyUniforms.mieCoefficient, "value", 0, 0.01, 0.0001).name("mieCoefficient").listen();
    folder.add(skyUniforms.mieDirectionalG, "value", 0, 1, 0.01).name("mieDirectionalG").listen();
  }
}
