﻿/**
 * パフォーマンス測定
 * Performance Measurement
 */
// @ts-ignore
import Stats from "stats-js";
import { Negl } from "negl";

let stats: any;
/**
 * パフォーマンス測定用関数
 * stats-jsによるFPSの測定を行います。
 * Function for performance measurement
 * Measures FPS using stats-js.
 *
 * @param param Neglオブジェクト(Negl object)
 */
function performanceMonitor({ hook, config: { debug } }: Negl) {
  if (debug) {
    stats = new Stats();
    document.body.appendChild(stats.dom);
  }
  hook.on(hook.RENDER, () => {
    if (debug) {
      // end と begin を逆にすることで、前回のループの begin から 今回のループの end までにかかった時間（１ループの処理時間）を測定する。
      // By reversing end and begin, we measure the time taken from the beginning of the last loop to the end of the current loop (the processing time for one loop).
      stats.end();
      stats.begin();
    }
  });
}

export { performanceMonitor };
