export type ViewportOptions = {
    canvas: HTMLCanvasElement;
    cameraZ?: number;
    near?: number;
    far?: number;
    devicePixelRatio?: number;
};
export type ResizeCallback = (viewport?: Viewport) => void;
/**
 * 画面サイズとカメラの値を管理します。
 */
/**
 * 画面サイズとカメラの値を管理する {@link Viewport} クラスのオブジェクトです。
 *
 * `negl`ではマウスの位置情報を内部で保持しています。これはマウスに追従するアニメーションや、{@link meshUI メッシュへのインタラクション}のマウス座標、もしくはシェーダに渡るuMouse、uHoverの座標に用いられます。
 */
declare let viewport: Viewport;
/**
 * 画面サイズとカメラの値を管理します。
 *
 * このクラスは`negl`内部でインスタンス化され、{@link viewport} オブジェクトとして提供されます。
 *
 * **取得方法**
 * ```ts
 * import { viewport } from "../negl";
 * import { isMobile } from '../../examples/parts/helper/isMobile';
// or
 * window.negl.viewport
 * ```
 */
declare class Viewport {
    #private;
    /**
     * [PerspectiveCamera](https://threejs.org/docs/#api/en/cameras/PerspectiveCamera) のアスペクト（aspect）を保持します。
     * この値を用いて {@link World.camera} は作成されます。
     */
    aspect: number;
    /**
     * {@link World.camera} のz軸のポジションを保持します。
     */
    cameraZ: number;
    /**
     * レンダリング時に使用するピクセル比を保持します。
     * この値は [config.viewport.devicePixelRatio](/reference/interfaces/Config/#リサイズやカメラの情報設定) で変更可能です。
     */
    devicePixelRatio: number;
    /**
     * [PerspectiveCamera](https://threejs.org/docs/#api/en/cameras/PerspectiveCamera) のファー（far）を保持します。
     * この値は [config.viewport.far](/reference/interfaces/Config/#リサイズやカメラの情報設定) で変更可能です。
     * この値を用いて {@link World.camera} は作成されます。
     */
    far: number;
    /**
     * [PerspectiveCamera](https://threejs.org/docs/#api/en/cameras/PerspectiveCamera) のファー（fov）を保持します。
     * この値を用いて {@link World.camera} は作成されます。
     */
    fov: number;
    /**
     * #canvas 要素の縦幅を保持します。
     */
    height: number;
    /**
     * [PerspectiveCamera](https://threejs.org/docs/#api/en/cameras/PerspectiveCamera) のファー（near）を保持します。
     * この値は [config.viewport.near](/reference/interfaces/Config/#リサイズやカメラの情報設定) で変更可能です。
     * この値を用いて {@link World.camera} は作成されます。
     */
    near: number;
    /**
     * {@link fov} のラジアン単位の値を保持します。
     */
    rad: number;
    /**
     * #canvas 要素の縦幅を保持します。
     */
    width: number;
    /**
     * #canvas 要素を保持します。
     */
    canvas: HTMLCanvasElement;
    static init(options: ViewportOptions): Viewport;
    private constructor();
    init({ canvas, cameraZ, near, far, devicePixelRatio, }: ViewportOptions): Viewport;
    bindEvents(): void;
}
export { Viewport, viewport };
//# sourceMappingURL=viewport.d.ts.map