/**
 * 下層ページ（diverse.html）用制御ファイル
 * 概要：data-page="sub"をキーに実行される
 *
 * Control file for the subpage (diverse.html)
 * Overview: Executed with data-page="sub" as the key
 */
let particles;
import { world } from "negl";
import { addLoadingAnimation } from "#/parts/loading/loader-basic1/example";
export default async function () {
  // パーティクルのエフェクトを取得
  // Retrieve the particle effects
  particles = world.getObByEl("#particles");

  // ローディングアニメーションの追加
  // Adding the loading animation
  addLoadingAnimation(loadAnimation);
}

function loadAnimation(tl) {
  // パーティクルのアニメーション
  // Particle animation
  tl.set(
    {},
    {
      onComplete() {
        particles.uniforms.uProgress.value = 0.5;
        particles.goTo(0, 0.3);
      },
    }
  );
}
