import { Vector4 } from "three";
import { ShaderPass } from "three/examples/jsm/postprocessing/ShaderPass";
import { getComposer } from "#/parts/helper/getComposer";

let instance;
async function initDistortionPass({ world }) {
  /**
   * 2回以上Passをシーンに追加しないため、すでに instance が設定されている場合はそれを返却
   * To avoid adding the Pass to the scene more than twice, return the existing instance if one is already set.
   */
  if (instance) return instance;

  const o = await world.createOb(`
    <div class="load-pp" data-webgl="distortion" style="width: 1px; height: 1px;"></div>
  `);

  const { material, uniforms } = o;
  world.removeOb(o, false);
  uniforms.tDiffuse = { value: null };
  uniforms.uProgress.value = 1;
  uniforms.uReversal.value = 1;
  uniforms.uParam = { value: new Vector4(0, 20, 7, 2) };
  material.alphaTest = 0;
  const pass = new ShaderPass(material);
  const composer = getComposer();
  composer.addPass(pass);

  function setProgress(value) {
    uniforms.uProgress.value = value;
  }

  function removePass(dispose = true) {
    composer.removePass(pass);
    if (dispose) {
      o.geometry.dispose();
      o.material.dispose();
    }
  }

  function addPass() {
    composer.addPass(pass);
  }

  instance = {
    addPass,
    removePass,
    setProgress,
  };
  return instance;
}

export default initDistortionPass;
