﻿import { config, INode, Loader } from "negl";
import gsap from "gsap";

const $: { [key: string]: Element | null } = {};

function progressCounter(progress: number, total: number) {
  // ローディングの進捗情報をパーセントで表示
  // Display the loading progress information as a percentage
  const loaderPercent = INode.getElement(".loader-percent") as HTMLElement;
  loaderPercent.innerHTML = Math.round((progress / total) * 100) + "%";
}

function _loadingAnimationStart() {
  $.globalContainer = INode.getElement(config.$.globalContainer);
  $.loader = INode.getElement("#loader");

  const tl = gsap.timeline();
  tl.to($.loader!.firstElementChild, {
    opacity: 0,
    y: 10,
    duration: 0.3,
    delay: 0.5,
  })
    .set($.globalContainer, {
      visibility: "visible",
    })
    .set($.loader, {
      display: "none",
    });

  return tl;
}

async function _loadingAnimationEnd(tl: gsap.core.Timeline) {
  const page = INode.qsAll(`${config.$.pageContainer}, #asides`);

  return new Promise<void>((resolve) => {
    tl.to(page, {
      opacity: 1,
      duration: 1,
      onComplete() {
        // loader.isLoaded = true;
        resolve();
      },
    });
  });
}

let loadingAnimation: (tl: gsap.core.Timeline) => void = (tl) => {};

function addLoadingAnimation(
  _loadingAnimation: (tl: gsap.core.Timeline) => void
) {
  loadingAnimation = _loadingAnimation;
}

async function letsBegin() {
  const tl = _loadingAnimationStart();
  loadingAnimation(tl);
  return await _loadingAnimationEnd(tl);
}

export { progressCounter, addLoadingAnimation, letsBegin };
