﻿import { menu } from "#/parts/menu/three-bar-menu";

// トランジション 開始時
// Transition start
function registTransitionMenu(hook) {
  hook.on(hook.T_BEGIN, toggleMenu, { priority: 800 });
  hook.on(hook.T_END, menuMount);

  // メニューが開いている場合閉じます
  // Closes the menu if it is open
  async function toggleMenu() {
    /**
     * await を消せば、メニューが閉まるのを待たず後続のトランジション処理が実行される
     * If you remove 'await', the subsequent transition processes will execute without waiting for the menu to close
     */
    menu.isOpen && (await menu.toggle());
  }

  async function menuMount() {
    menu.reset();
  }
}

export { registTransitionMenu };
