import { Mouse, MeshUI } from '../component';
import { World } from '../glsl';
import { Object3D } from 'three';
export interface MouseAnimationHandlerArgs<T> {
    mouse: Mouse;
    effect: T;
    payload?: {
        [key: string]: any;
    };
}
export interface MouseAnimationHandler<T> {
    enter?: ({ mouse, effect, payload }: MouseAnimationHandlerArgs<T>) => void;
    move?: ({ mouse, effect, payload }: MouseAnimationHandlerArgs<T>) => void;
    leave?: ({ mouse, effect, payload }: MouseAnimationHandlerArgs<T>) => void;
}
export interface MouseAnimationHandlers<T> {
    [key: string]: MouseAnimationHandler<T>;
}
export declare abstract class AbstractMouseEffect {
    handlers: MouseAnimationHandlers<typeof this>;
    handlerTargets: HTMLElement[];
    handlerRemovers: (() => void)[];
    protected world: World;
    protected mouse: Mouse;
    protected meshUI: MeshUI;
    constructor(world: World, mouse: Mouse, meshUI: MeshUI);
    bindEvents(): void;
    hideDefaultCursor(): boolean;
    attachHandlers(handlers?: MouseAnimationHandler<typeof this>): void;
    detachHandlers(): void;
    abstract init(): Promise<void>;
    abstract move(mouse: Mouse): void;
    abstract resize(): void;
    abstract meshEnter(mesh: Object3D<THREE.Event>): void;
    abstract meshLeave(mesh: Object3D<THREE.Event>): void;
    abstract meshClick(mesh: Object3D<THREE.Event>): void;
}
//# sourceMappingURL=mouse-effect.d.ts.map