import * as fs from "fs";
import * as ejs from "ejs";
// const fs = require("fs");
// const ejs = require("ejs");

// JSONデータを読み込む
// Load JSON data
const jsonData = fs.readFileSync("./script/seed.json", "utf-8");
const data = JSON.parse(jsonData);

// EJSテンプレートを読み込む
// Load the EJS template
const template = fs.readFileSync("./script/detail.ejs", "utf-8");

// JSONデータのキーを配列に格納
// Store the keys of the JSON data in an array
const keys = [
  "index",
  "Hokkaido",
  "Osaka",
  "Okinawa",
  "Kyoto",
  "Tottori",
  "Nara",
  "Tokyo",
  "Shiga",
  "Wakayama",
];

keys.forEach((key, idx) => {
  const target = data[key];
  console.log(target);
  target.data = data;
  target.key = key;
  target.idx = idx;
  target.navs = [
    keys.at((idx - 1) % keys.length),
    keys.at((idx + 2) % keys.length),
    keys.at((idx + 1) % keys.length),
  ];

  // EJSテンプレートを使用してHTMLを生成
  // Generate HTML using the EJS template
  const renderedHtml = ejs.render(template, target);

  // 生成されたHTMLをファイルに保存
  // Save the generated HTML to a file
  fs.writeFileSync(`./src/${key.toLowerCase()}.html`, renderedHtml);
});

console.log("HTML was successfully generated.");
