
varying vec2 vUv;
uniform sampler2D tex1;
uniform float uHover;
uniform float uAlpha;
uniform vec4 uResolution;

#pragma glslify: coverUv = require(../shader-util/coverUv)
#pragma glslify: grayscale = require(../shader-util/grayscale)

void main() {
  vec2 uv = coverUv(vUv, uResolution);
  
  // plane color
  vec4 tex = texture(tex1, uv);
  vec4 gray = grayscale(tex);
  vec4 color = mix(gray, tex, uHover);

  gl_FragColor = color;
  gl_FragColor.a *= uAlpha;

}