import { SphereGeometry, PlaneGeometry, Group } from "three";
import gsap from "gsap";

import { Ob } from "negl";
import vertexShader from "./vertex.glsl";
import fragmentShader from "./fragment.glsl";

export default class extends Ob {
  setupMesh() {
    this.uniforms.uAlpha.value = 1;
    this.plane = super.setupMesh();
    const group = new Group;
    group.add(this.plane);
    return group;
  }
  setupVertex() {
    return vertexShader;
  }
  setupFragment() {
    return fragmentShader;
  }
  render(tick) {
    super.render(tick);

    if(this.uniforms.uHover.value === 0 && this.resizing) return;

    this.plane.position.x = (this.uniforms.uMouse.value.x - 0.5) * 50. * this.uniforms.uHover.value;
    this.plane.position.y = (this.uniforms.uMouse.value.y - 0.5) * 50. * this.uniforms.uHover.value;

    this.plane.position.z = 200 * this.uniforms.uHover.value;
    
    this.plane.rotation.x = -(this.uniforms.uMouse.value.y - 0.5) * this.uniforms.uHover.value / 1.5;
    this.plane.rotation.y = (this.uniforms.uMouse.value.x - 0.5) * this.uniforms.uHover.value / 1.5;
  }
  debug(folder) {
    
    folder
      .add(this.uniforms.uProgress, "value", 0, 1, 0.1)
      .name("progress")
      .listen();
    const datObj = { next: !!this.uniforms.uProgress.value };
    folder
      .add(datObj, "next")
      .name("Animate")
      .onChange(() => {
        gsap.to(this.uniforms.uProgress, {
          value: +datObj.next,
          duration: 2,
          ease: "power2.out",
        });
      });
  }
}
