import { Ob } from "negl";
import vertexShader from "./vertex.glsl";
import fragmentShader from "./fragment.glsl";
import { PlaneGeometry } from "three";

export default class extends Ob {
  setupUniforms() {
    const uniforms = super.setupUniforms();
    uniforms.uAlpha.value = 1;
    return uniforms;
  }
  setupGeometry() {
    return new PlaneGeometry(this.rect.width, this.rect.height, 10, 10);
  }
  setupVertex() {
    return vertexShader;
  }
  setupFragment() {
    return fragmentShader;
  }
  debug(folder) {
    folder.add(this.uniforms.uAlpha, "value", 0, 1, 0.01);
  }
}
