varying vec2 vUv;
uniform vec4 uResolution;
uniform float uAlpha;
uniform float uProgress;
uniform sampler2D tex1;

varying float vDistProgress;
varying float vScaleProgress;

#pragma glslify: grayscale = require(../shader-util/grayscale)
#pragma glslify: coverUv = require(../shader-util/coverUv);

void main() {
    vec2 uv = coverUv(vUv, uResolution);
    uv -= 0.5;

    float scale = mix(0.7, 1.0, vScaleProgress);
    uv *= scale;

    uv += 0.5;

    gl_FragColor = texture2D(tex1, uv);

    float alphaProgress = smoothstep(0.7, 0.9, vDistProgress);
    gl_FragColor.a = mix(0., gl_FragColor.a, alphaProgress * uAlpha);
}