uniform vec4 uResolution;
uniform float uAlpha;
uniform float uCurve;
uniform sampler2D tex1;

varying vec2 vUv;
varying float vDistProgress;

#pragma glslify: coverUv = require(../shader-util/coverUv);

void main() {
    vec2 uv = coverUv(vUv, uResolution);

    vec4 t1 = texture2D(tex1, uv);
    float alphaProgress = smoothstep(0.7, 0.9, vDistProgress);
    gl_FragColor.a = mix(0., t1.a, alphaProgress * uAlpha);
}