varying vec2 vUv;

uniform float uRadius;
uniform float uSlideIdx;
uniform float uActiveSlideIdx;
uniform float uDist;
uniform float uSlideTotal;

varying float vDistProgress;
varying float vScaleProgress;

void main() {
    vUv = uv;

    vec3 pos = position;

    float activeSlideIdx = mod(uActiveSlideIdx, uSlideTotal);
    float dist = abs(activeSlideIdx - uSlideIdx);
    float deepest = uSlideTotal / 2.;

    float distProgress = abs(dist - deepest) / deepest;
    vDistProgress = distProgress;

    float scaleProgress = clamp((distProgress - uDist) * 5., 0., 1.);
    vScaleProgress = scaleProgress;

    float roundZ = uRadius - sqrt(pow(uRadius, 2.) - pow(pos.y, 2.));
    pos.z -= roundZ;
    
    gl_Position = projectionMatrix * modelViewMatrix * vec4(pos, 1.);
}