// 参考
// https://github.com/Anemolo/WebGLDistortionConfigurator
uniform float uProgress;
const vec2 uPlaneCenter = vec2(0., 0.);
const float uSeed = 0.;
varying vec2 vUv;

// slider-slot関連
uniform float uRadius;
uniform float uSlideIdx;
uniform float uActiveSlideIdx;
uniform float uTick;
uniform float uDist;
uniform float uSlideTotal;
uniform float uCurve;

varying float vDistProgress;
varying float vScaleProgress;

#pragma glslify: snoise = require(glsl-noise/simplex/2d.glsl)
#pragma glslify: parabola = require(../shader-util/parabola.glsl)

float getActivation(vec2 uv) {
    return (uv.x + 1.- uv.y)/2.;
}

void main() {
    vec3 pos = position.xyz;
    vec2 newUV = uv;
    float activation = getActivation(uv);
    float vertexProgress = uProgress;
    float startAt = activation * 0.5;
    vertexProgress = smoothstep(startAt, 1., uProgress);
    vec3 transformedPos = pos;
    vec2 transformedUV = uv;
    float simplexProgress = min(clamp((vertexProgress) / 0.25, 0., 1.), clamp((1.-vertexProgress) / (1.-0.25), 0., 1.));
    simplexProgress = smoothstep(0., 1., simplexProgress);
    float noiseX = snoise(vec2(transformedPos.x +uSeed, transformedPos.y + uSeed + simplexProgress * 1.) * 0.4 ) ;
    float noiseY = snoise(vec2(transformedPos.y +uSeed, transformedPos.x + uSeed + simplexProgress * 1.) * 0.3) ;
    transformedPos.x += 1. * noiseX * simplexProgress;
    transformedPos.y += 0.2 * noiseY * simplexProgress;
    pos = transformedPos;
    newUV = transformedUV; 
    
    // Scale
    vec2 scale = vec2(
    1. + parabola(vertexProgress, .5) * .7
    );
    // Since we are moving the mesh not the geometry the geometry is in the center
    
    pos.xy *= scale;
    // Move to center
    
    // Mesh moves it into position. Shader moves it to the center
    pos.y += -uPlaneCenter.y * vertexProgress;
    pos.x += -uPlaneCenter.x * vertexProgress;


    // シリンダーの曲面に沿わせる
    float roundZ = uRadius - sqrt(pow(uRadius, 2.) - pow(pos.y, 2.));
    pos.z -= roundZ * uCurve;

    // slot関連
    float activeSlideIdx = mod(uActiveSlideIdx, uSlideTotal);
    float dist = abs(activeSlideIdx - uSlideIdx);
    float deepest = uSlideTotal / 2.; // 5 / 2 = 2.5
    float distProgress = abs(dist - deepest) / deepest;
    vDistProgress = distProgress;

    float scaleProgress = clamp((distProgress - uDist) * 5., 0., 1.);
    vScaleProgress = scaleProgress;
    
    pos.xy *= (0.9 + 0.1 * scaleProgress);
    
    // Move slightly to the front
    
    gl_Position = projectionMatrix * modelViewMatrix * vec4(pos, 1.);
    vUv = newUV;
}