﻿/**
 * GPUパフォーマンスを測定し、Low Performance の判定を可能とします。
 * Measures GPU performance and enables the determination of Low Performance.
 */
import { config } from "negl";

/**
 * detect-gpu - https://www.npmjs.com/package/detect-gpu
 */
import { getGPUTier } from "detect-gpu";

// GPUパフォーマンスの算出
// Calculation of GPU performance
let _isHighPerformanceMode: boolean;
/**
 * GPUの測定を行います。
 * Measures the GPU performance.
 *
 * detect-gpu - https://www.npmjs.com/package/detect-gpu
 *
 * @param _tier GPU tier
 * @param _fps GPU fps
 */
async function definePerformanceMode(_tier: number = 2, _fps: number = 50) {
  const gpuTier = await getGPUTier();
  /**
   * デバッグモードの時、GPUの詳細情報をログに出力
   * Outputs detailed GPU information to the log when in debug mode.
   */
  if (config.debug) {
    console.log(gpuTier);
  }
  _isHighPerformanceMode = gpuTier.tier >= _tier && gpuTier.fps! >= _fps;
}

/**
 * Low Performance の時、true。それ以外、false を返します。
 * Returns true for Low Performance, otherwise false.
 * @returns {boolean}
 */
function isLowPerformanceMode(): boolean {
  if (typeof _isHighPerformanceMode !== "boolean") {
    throw new Error("definePerformanceMode(tier, fps)を先に実行してください。");
    // Please execute definePerformanceMode(tier, fps) first.
  }
  return !_isHighPerformanceMode;
}

export { definePerformanceMode, isLowPerformanceMode };
