import { Vector3, Quaternion } from "three";
/**
 * ワールド座標に変換されたクローンされたメッシュを返します。
 * Returns a cloned mesh that has been transformed into world coordinates.
 * @param {THREE.Object3D} mesh
 * @returns {THREE.Object3D} ワールド座標を基点としたクローンされたメッシュ. A cloned mesh based on world coordinates
 */
export function getWorldCoordClonedMesh(mesh) {
  // 子メッシュのワールド座標系における位置、回転、スケールを取得
  // Get the position, rotation, and scale of the child mesh in the world coordinate system.
  const worldPosition = new Vector3();
  const worldQuaternion = new Quaternion();
  const worldScale = new Vector3();

  // ワールドマトリックスを最新に更新
  // Update the world matrix to the latest
  mesh.updateMatrixWorld(true);
  // 対象のメッシュのワールド座標をベースにした値を取得
  // Get the values based on the world coordinates of the target mesh
  mesh.getWorldPosition(worldPosition);
  mesh.getWorldQuaternion(worldQuaternion);
  mesh.getWorldScale(worldScale);

  // メッシュのクローンを作成し、取得した位置、回転、スケールをメッシュに設定
  // Create a clone of the mesh and set the obtained position, rotation, and scale to the mesh
  const cloned = mesh.clone();
  cloned.position.copy(worldPosition);
  cloned.quaternion.copy(worldQuaternion);
  cloned.scale.copy(worldScale);

  return cloned;
}
