﻿/**
 * サファリブラウザでブラウザタブが非アクティブな状態から復帰した際に画面をリロードします。
 * Reloads the page when a browser tab in Safari becomes active again after being inactive.
 * @param { utils }
 */
export function reloadOnSafari({ utils }) {
  window.addEventListener("focus", () => {
    if (utils.isIOS()) {
      // iPhone、iPadの時は画面をリロード
      // Reload the page on iPhone or iPad
      window.location.reload();
    }
  });
}
