﻿import { config, INode } from "negl";
import gsap from "gsap";

const $ = {};

/**
 * 読み込みの進捗をパーセント表示でDOMに反映
 * Reflect the loading progress in the DOM as a percentage
 * @param {*} progress
 * @param {*} total
 */
function progressCounter(progress, total) {
  // ローディングの進捗情報をパーセントで表示
  // Display the loading progress information as a percentage
  const loaderPercent = INode.getElement(".loader-percent");
  loaderPercent.innerHTML = Math.round((progress / total) * 100) + "%";
}

/**
 * #loader のフェードアウトと #global-container の表示
 * Fade out the #loader and display the #global-container
 */
function _loadingAnimationStart() {
  $.globalContainer = INode.getElement(config.$.globalContainer);
  $.loader = INode.getElement("#loader");

  const tl = gsap.timeline();
  tl.to($.loader.firstElementChild, {
    opacity: 0,
    y: 10,
    duration: 0.3,
    delay: 0.5,
  })
    .set($.globalContainer, {
      visibility: "visible",
    })
    .set($.loader, {
      display: "none",
    });

  return tl;
}

/**
 * .page-container をフェードイン
 * Fade in the .page-container
 */
async function _loadingAnimationEnd(tl) {
  const page = INode.qsAll(`${config.$.pageContainer}, #asides`);

  return new Promise((resolve) => {
    tl.to(page, {
      opacity: 1,
      duration: 1,
      onComplete() {
        resolve();
      },
    });
  });
}

// ローディングアニメーション
// addLoadingAnimationで関数が登録されなくてもエラーにならないように関数を初期値に設定
// Loading animation
// Set a default function for addLoadingAnimation to prevent errors even if no function is registered
let loadingAnimation = (tl) => {};

function addLoadingAnimation(_loadingAnimation) {
  loadingAnimation = _loadingAnimation;
}

async function letsBegin() {
  const tl = _loadingAnimationStart();
  loadingAnimation(tl);
  return await _loadingAnimationEnd(tl);
}

export { progressCounter, addLoadingAnimation, letsBegin };
