var Nt = Object.defineProperty;
var zt = (u, e, t) => e in u ? Nt(u, e, { enumerable: !0, configurable: !0, writable: !0, value: t }) : u[e] = t;
var a = (u, e, t) => (zt(u, typeof e != "symbol" ? e + "" : e, t), t), ze = (u, e, t) => {
  if (!e.has(u))
    throw TypeError("Cannot " + t);
};
var o = (u, e, t) => (ze(u, e, "read from private field"), t ? t.call(u) : e.get(u)), d = (u, e, t) => {
  if (e.has(u))
    throw TypeError("Cannot add the same private member more than once");
  e instanceof WeakSet ? e.add(u) : e.set(u, t);
}, E = (u, e, t, s) => (ze(u, e, "write to private field"), s ? s.call(u, t) : e.set(u, t), t);
var Be = (u, e, t, s) => ({
  set _(i) {
    E(u, e, i, t);
  },
  get _() {
    return o(u, e, s);
  }
}), w = (u, e, t) => (ze(u, e, "access private method"), t);
import { Vector4 as Ge, Vector3 as je, Quaternion as Bt, TextureLoader as jt, LinearFilter as ge, VideoTexture as Ft, Vector2 as We, PlaneGeometry as Vt, ShaderMaterial as ft, Mesh as Gt, Raycaster as Wt, Scene as qt, WebGLRenderer as Yt, Clock as Zt, PerspectiveCamera as ct, AxesHelper as Xt } from "three";
const h = {
  resolver: {
    ob: {},
    page: {}
  },
  // HTML内の主要なID属性の設定（styles/parts/_common.scss内のセレクタも合わせて要変更）
  $: {
    canvas: "#canvas",
    globalContainer: "#global-container",
    pageContainer: ".page-container"
  },
  // HTML内のdata-〇〇に指定する名前の設定
  prefix: {
    ob: "webgl",
    tex: "tex",
    page: "page",
    click: "click",
    transition: "transition",
    interactive: "interactive"
  },
  // HTML内の主要なイベント名の設定
  event: {
    resize: "resize",
    mouse: "mouse",
    click: "click"
  },
  transition: {
    spaMode: !1,
    cache: !1,
    defaultType: ""
  },
  viewport: {
    autoresize: !0,
    resizeDuration: 1,
    delay: 500,
    devicePixelRatio: 1,
    cameraZ: 2e3,
    near: 1500,
    far: 4e3
  },
  world: {
    autoRender: !0,
    clearColor: "#000000",
    clearAlpha: 1
  },
  mouse: {
    speed: 0.2
  },
  meshUI: {},
  scroller: {
    damping: 0.5
  },
  gui: { guiOpen: !1, folderOpen: !1 },
  addon: {
    lilGUI: void 0
  },
  debug: !1
}, Kt = (u) => (gt(h, u), h);
function gt(u, e) {
  const t = u;
  for (const s in e)
    typeof e[s] == "object" && e[s] !== null && !Array.isArray(e[s]) && u.hasOwnProperty(s) && typeof u[s] == "object" ? t[s] = gt(u[s], e[s]) : t[s] = e[s];
  return t;
}
const Fe = window.navigator.userAgent.toLowerCase(), Ve = /* @__PURE__ */ new WeakMap();
class Qt {
  /**
   * タッチデバイスかどうかを判定します。
   *
   * @returns タッチデバイスの時、true。それ以外、false。
   */
  isTouchDevices() {
    return "ontouchstart" in window;
  }
  /**
   * Lerp 関数
   * @param a 始点
   * @param b 終点
   * @param n 線形補間要素（0 ~ 1）
   * @param limit limit まで値が近づくと終点の値を返す
   * @returns 線形補間された値
   */
  lerp(e, t, s = 0.3, i = 1e-3) {
    let n = (1 - s) * e + s * t;
    return Math.abs(t - n) < i && (n = t), n;
  }
  /**
   * テクスチャのアスペクト値の算出
   *    * テクスチャとHTML要素の大きさのアスペクト比からuResolutionを設定します。
   * @param {DOMRect} toRect 要素の矩形を渡します。
   * @param {HTMLImageElement | HTMLVideoElement} mediaRect 画像、または動画のオリジナルサイズを渡します。
   * @returns {Vector4} uResolution に設定する Vector4 オブジェクト
   * x: DOMの横幅
   * y: DOMの縦幅
   * z: 横幅に掛ける縦横比
   * w: 縦幅に掛ける縦横比
   */
  getResolutionUniform(e, t) {
    const { width: s, height: i } = e, n = new Ge(s, i, 1, 1);
    if (!t)
      return n;
    const { width: r, height: l } = t, f = l / r, p = i / s;
    let x, m;
    return p > f ? (x = 1 / p * f, m = 1) : (x = 1, m = p / f), n.z = x, n.w = m, n;
  }
  /**
   * 対角線上に頂点を詰めた配列を返却します
   * @param hSeg 高さのセグメント数
   * @param wSeg 幅のセグメント数
   * @param getValue 頂点毎に返却する値
   * @param defaultValue デフォルト値
   * @returns 頂点データの１次元配列を返却します。
   */
  getDiagonalVertices(e, t, s, i) {
    const n = e + 1, r = t + 1;
    let l = [], f = i;
    for (let p = 0; p < n + r - 1; p++)
      for (let x = Math.min(n, p + 1) - 1; x >= Math.max(0, p - r + 1); x--) {
        let m = x * r + p - x;
        f = s(f, m), l[m] = f;
      }
    return l;
  }
  /**
   * １次元の配列をテーブル形式で出力します
   * @param targetMatrix コンソールログに出力対象の配列を渡します。
   * @param col 列数を指定します。
   * @param label テーブルのラベルを指定します。
   * @returns
   */
  printMat(e, t = 4, s = "") {
    let i;
    e.elements !== void 0 ? i = e.elements : e.array !== void 0 ? i = Array.from(e.array) : i = e, console.log(i), Array.isArray(i) && setTimeout(() => {
      let n = i.reduce((r, l, f) => (f % t === 0 && r.push([]), r[r.length - 1].push(l), r), []);
      console.log(
        `%c${s}`,
        "font-size: 1.3em; color: red; background-color: #e4e4e4;"
      ), console.table(n);
    });
  }
  /**
   * メッシュの向きを指定の方向に回転します
   * @param _mesh 回転したいメッシュ
   * @param originalDir 元の向き
   * @param targetDir 向けたい向き
   */
  pointTo(e, t, s) {
    const i = new je(
      t.x,
      t.y,
      t.z
    ).normalize(), n = new je(
      s.x,
      s.y,
      s.z
    ).normalize(), r = new je().crossVectors(i, n).normalize(), l = i.dot(n), f = Math.acos(l), p = new Bt();
    p.setFromAxisAngle(r, f), e.rotation.setFromQuaternion(p);
  }
  /**
   * サファリブラウザかどうかを判定します。
   * @returns サファリの時 true。それ以外、false。
   */
  isSafari() {
    return !!/^((?!chrome|android).)*safari/i.test(Fe);
  }
  /**
   * iphone、ipadかどうかを判定します。
   * @returns iphone、ipadの時 true。それ以外、false。
   */
  isIOS() {
    return Fe.indexOf("iphone") !== -1 || Fe.indexOf("ipad"), !1;
  }
  /**
   * ケバブケースからキャメルケースへ文字列を変換します
   */
  toCamelCase(e) {
    return e.replace(/-./g, (t) => t[1].toUpperCase());
  }
  /**
   * HTMLの座標をワールド座標に変換します。
   * @param rect 対象のHTMLのDOMRect
   * @param viewport Canvasのビューポート
   * @returns
   */
  getWorldPosition(e, t) {
    const s = e.left + e.width / 2 - t.width / 2, i = -e.top - e.height / 2 + t.height / 2;
    return { x: s, y: i };
  }
  /**
   * `{ href, target }` を含むオブジェクトを返します。
   * `data-click-*` の値を `split` した配列からURLを取得する際に利用しています。
   *
   * ```js
   * console.log(utils.getHrefObj('newTab,/detail.html'.split()));
   * // > { href="/detail.html", target="_blank" }
   *
   * console.log(utils.getHrefObj('/detail.html'.split()));
   * // > { href="/detail.html", target="_self" }
   * ```
   */
  getHrefObj(e = []) {
    if (e.length === 0) {
      h.debug && console.info("URLが見つからないため、クリック処理を終了します。");
      return;
    }
    let t = "_self", s;
    return e.length > 1 ? (e[0].toLowerCase().trim() === "newtab" && (t = "_blank"), s = e[1]) : e.length > 0 && (s = e[0]), s = s.trim(), { href: s, target: t };
  }
  /**
   * [gsap.to](https://greensock.com/docs/v3/GSAP/gsap.to())の簡易版
   * ライセンスの問題と依存するライブラリを増やしたくなかったため、gsap.toの簡易版の関数を作成しました。
   *
   * 基本的には gsap.to と使い方は変わりませんが、ease や delay は使用できません。
   * また、gsap.to と異なり、utils.tween では gsap.to の overwrite オプションが常に true の状態の tween となります。
   * ```js
   * const progress = { value: 0, value2: 1 }
   * utils.tween(progress, {
   *  value: 1,   // progress.value は 1 秒かけて　0 -> 1 に遷移します。
   *  value2: 0,  // progress.value2 は 1 秒かけて　1 -> 0 に遷移します。
   *  duration: 1,
   *  onStart() { console.log('スタート時に実行されます。') },
   *  onUpdate(progress) { console.log('アップデート時に実行されます。') },
   *  onComplete() { console.log('終了時に実行されます。') },
   * })
   * ```
   */
  tween(e, t) {
    const {
      duration: s,
      limit: i = 1e-4,
      onStart: n,
      onUpdate: r,
      onComplete: l
    } = t, f = s * 1e3, p = { ...t };
    delete p.duration, delete p.limit, delete p.onStart, delete p.onUpdate, delete p.onComplete, n == null || n();
    let x = 0, m = 1, M = (/* @__PURE__ */ new Date()).getTime();
    Ve.delete(e);
    const $ = { ...e }, C = this;
    function j() {
      const N = (/* @__PURE__ */ new Date()).getTime() - M, v = Math.min(1, N / (f + 1)), K = C.lerp(x, m, v, i);
      for (const [D, $t] of Object.entries(p))
        D in e && (e[D] = C.lerp($[D], $t, K));
      if (r == null || r(K), N < f) {
        const D = Ve.get(e);
        D && window.requestAnimationFrame(D);
      } else
        l == null || l();
    }
    window.requestAnimationFrame(() => {
      Ve.set(e, j), j();
    });
  }
}
const y = new Qt();
let b;
var ye, pt;
const rt = class rt {
  constructor(e) {
    d(this, ye);
    /**
     * [PerspectiveCamera](https://threejs.org/docs/#api/en/cameras/PerspectiveCamera) のアスペクト（aspect）を保持します。
     * この値を用いて {@link World.camera} は作成されます。
     */
    a(this, "aspect", 0);
    /**
     * {@link World.camera} のz軸のポジションを保持します。
     */
    a(this, "cameraZ", 0);
    /**
     * レンダリング時に使用するピクセル比を保持します。
     * この値は [config.viewport.devicePixelRatio](/reference/interfaces/Config/#リサイズやカメラの情報設定) で変更可能です。
     */
    a(this, "devicePixelRatio", 1);
    /**
     * [PerspectiveCamera](https://threejs.org/docs/#api/en/cameras/PerspectiveCamera) のファー（far）を保持します。
     * この値は [config.viewport.far](/reference/interfaces/Config/#リサイズやカメラの情報設定) で変更可能です。
     * この値を用いて {@link World.camera} は作成されます。
     */
    a(this, "far", 0);
    /**
     * [PerspectiveCamera](https://threejs.org/docs/#api/en/cameras/PerspectiveCamera) のファー（fov）を保持します。
     * この値を用いて {@link World.camera} は作成されます。
     */
    a(this, "fov", 0);
    /**
     * #canvas 要素の縦幅を保持します。
     */
    a(this, "height", 0);
    /**
     * [PerspectiveCamera](https://threejs.org/docs/#api/en/cameras/PerspectiveCamera) のファー（near）を保持します。
     * この値は [config.viewport.near](/reference/interfaces/Config/#リサイズやカメラの情報設定) で変更可能です。
     * この値を用いて {@link World.camera} は作成されます。
     */
    a(this, "near", 0);
    /**
     * {@link fov} のラジアン単位の値を保持します。
     */
    a(this, "rad", 0);
    /**
     * #canvas 要素の縦幅を保持します。
     */
    a(this, "width", 0);
    /**
     * #canvas 要素を保持します。
     */
    // @ts-ignore
    a(this, "canvas");
    this.init(e), this.bindEvents();
  }
  static init(e) {
    return b || (b = new rt(e)), b;
  }
  init({
    canvas: e,
    cameraZ: t = 2e3,
    near: s = 1500,
    far: i = 4e3,
    devicePixelRatio: n = 1
  }) {
    this.canvas = e;
    const r = g.getRect(e);
    return this.width = r.width, this.height = r.height, this.near = s, this.far = i, this.cameraZ = t, this.aspect = this.width / this.height, this.rad = 2 * Math.atan(this.height / 2 / t), this.fov = this.rad * (180 / Math.PI), this.devicePixelRatio = n, b;
  }
  bindEvents() {
    let e;
    window.addEventListener(h.event.resize, () => {
      const t = this.width;
      w(this, ye, pt).call(this), !(y.isTouchDevices() && t === this.width) && (c.trigger(c.RESIZE, this), clearTimeout(e), e = window.setTimeout(() => {
        c.trigger(c.RESIZE_DELAY, this);
      }, h.viewport.delay));
    });
  }
};
ye = new WeakSet(), pt = function() {
  const { near: e, far: t, cameraZ: s } = b;
  this.init({ canvas: this.canvas, cameraZ: s, near: e, far: t });
};
let qe = rt, z;
var O, V;
const nt = class nt {
  constructor(e) {
    d(this, O, void 0);
    d(this, V, void 0);
    E(this, V, e), this.init();
  }
  static async init() {
    if (!z) {
      const { lilGUI: e } = mt;
      z = new nt(e);
    }
    return z;
  }
  init() {
    o(this, V) && h.debug && (E(this, O, new (o(this, V))()), h.gui.guiOpen || o(this, O).close());
  }
  /**
   * lil-guiにGUIを追加します。
   * 
   * ```js
   * const { gui } = negl
   * gui.add(lilGUI => {
   *   const folder = lilGUI.addFolder('folder-name');
   *   folder.add(someObject, 'value', 0, 1, 0.1);
   * })
   * ```
   * 
   * @param {(gui: lilGUI) => void}
   * @returns 
   */
  add(e) {
    o(this, O) && h.debug && e(o(this, O));
  }
  addRecommendGUI(e) {
    o(this, O) && h.debug && (e.addOrbitControlGUI(o(this, O), !1), e.os.forEach((t) => this.addObDebug(t)));
  }
  addObDebug(e) {
    if (!(o(this, O) && h.debug) || typeof e.debug != "function")
      return;
    const t = g.getDS(e.$.el, h.prefix.ob), s = o(this, O).addFolder(t);
    h.gui.folderOpen || s.close(), e.debug(s);
  }
  /**
   * lilGUIインスタンスを破棄します。
   * @returns 
   */
  destroy() {
    o(this, O) && h.debug && o(this, O).destroy();
  }
  /**
   * lilGUIのインスタンスを取得します。
   * @returns {lilGUI}
   */
  getLilGuiInstance() {
    return o(this, O);
  }
};
O = new WeakMap(), V = new WeakMap();
let Ye = nt;
class g {
  /**
   * [querySelector](https://developer.mozilla.org/ja/docs/Web/API/Document/querySelector)のアダプタ
   * @param selector セレクタ文字列
   * @param scope querySelectorの検索範囲
   * @returns 
   */
  static qs(e, t) {
    return (t || document).querySelector(e);
  }
  /**
   * [querySelectorAll](https://developer.mozilla.org/ja/docs/Web/API/Document/querySelectorAll)のアダプタ
   * @param selector セレクタ文字列
   * @param { Document | Element } [scope=document] querySelectorAllの検索範囲
   * @returns 
   */
  static qsAll(e, t) {
    const s = (t || document).querySelectorAll(e);
    return Array.from(s);
  }
  /**
   * 引数で渡されたHTML文字列をDOMにして返却します。
   * @param selector HTML文字列
   * @returns HTML文字列から変換されたDOM
   */
  static htmlToEl(e) {
    const t = document.createElement("div");
    return t.innerHTML = e, t.firstElementChild;
  }
  /**
   * [Element](https://developer.mozilla.org/ja/docs/Web/API/Element)の場合 true が返ります。それ以外、false。
   */
  static isElement(e) {
    return e instanceof Element;
  }
  /**
   * セレクタ文字列、またはDOMを受け取り、DOMを返却します。
   * @param selector セレクタ文字列
   * @param scope querySelectorの検索範囲
   */
  static getElement(e, t) {
    return g.isElement(e) ? e : g.qs(e, t);
  }
  /**
   * セレクタ文字列、またはDOMに対応する[DOMRect](https://developer.mozilla.org/ja/docs/Web/API/DOMRect)を返却します。
   * @param elementOrSelector セレクタ文字列、またはDOM
   */
  static getRect(e) {
    const t = g.getElement(e);
    return (t == null ? void 0 : t.getBoundingClientRect()) ?? null;
  }
  /**
   * 対象のDOMのキーに対応するdatasetの値を取得します。
   * @param elementOrSelector セレクタ文字列、またはDOM
   * @param key datasetのキー
   */
  static getDS(e, t) {
    var i;
    const s = g.getElement(e);
    return (i = s == null ? void 0 : s.dataset) == null ? void 0 : i[t];
  }
  /**
   * 対象のDOMのdatasetにキーが存在する場合、trueを返します。それ以外の場合、false。
   * @param elementOrSelector セレクタ文字列、またはDOM
   * @param key datasetのキー
   */
  static hasDS(e, t) {
    const s = g.getElement(e);
    return t in (s == null ? void 0 : s.dataset);
  }
  /**
   * [addEventListener](https://developer.mozilla.org/ja/docs/Web/API/EventTarget/addEventListener)のアダプタ
   * @param elementOrSelector セレクタ文字列、またはDOM
   * @param type イベントタイプ
   * @param fn コールバック関数
   * @param options イベントリスナのオプション
   */
  static addListener(e, t, s, i) {
    const n = g.getElement(e);
    n == null || n.addEventListener(t, s, i);
  }
  /**
   * [removeEventListener](https://developer.mozilla.org/ja/docs/Web/API/EventTarget/removeEventListener)のアダプタ
   * @param elementOrSelector セレクタ文字列、またはDOM
   * @param type イベントタイプ
   * @param fn イベント削除するコールバック関数
   * @param options イベントリスナのオプション
   */
  static removeListener(e, t, s, i) {
    const n = g.getElement(e);
    n == null || n.removeEventListener(t, s, i);
  }
}
const mt = {};
class wt {
  constructor() {
    a(this, "resolver");
  }
  set(e) {
    if (!(typeof e == "function" || typeof e == "object" && e !== null))
      throw new Error("Resolverにはオブジェクト、または関数を設定してください。");
    this.resolver = e;
  }
  async get(e) {
    let t;
    if (typeof this.resolver == "function")
      try {
        return await this.resolver(e);
      } catch (s) {
        if (h.debug) {
          console.error(s);
          debugger;
        }
      }
    else
      t = this.resolver[e];
    return t || (t = {}, h.debug && console.warn(`"${e}"はResolverには登録されていない、もしくはエラーが発生しているため、処理をスキップします。`)), t;
  }
}
const Ee = new wt(), Et = new wt();
class vt {
  constructor() {
    /**
     * ページ毎のデフォルト関数実行前
     * @internal
     */
    a(this, "BEFORE_PAGE_INIT", 90);
    /**
     * マウスが動いた時
     * @internal
     */
    a(this, "MOUSEMOVE", 100);
    /**
     * マウスがメッシュに入った時
     * @internal
     */
    a(this, "MOUSE_MESH_ENTER", 200);
    /**
     * マウスがホバー中
     * @internal
     */
    a(this, "MOUSE_MESH_HOVER", 210);
    /**
     * マウスがメッシュから出た時
     * @internal
     */
    a(this, "MOUSE_MESH_LEAVE", 220);
    /**
     * マウスがメッシュをクリックした時
     * @internal
     */
    a(this, "MOUSE_MESH_CLICK", 230);
    /**
     * スクロールしている時
     * @internal
     */
    a(this, "SCROLL", 300);
    /**
     * フレーム毎の実行時
     * @internal
     */
    a(this, "RENDER", 400);
    /**
     * フレーム毎の実行時（必ず実行したいもの）
     * @internal
     */
    // readonly RENDER_NEED = 450;
    /**
     * 画面サイズが変わった時
     * @internal
     */
    a(this, "RESIZE", 500);
    /**
     * 画面サイズの更新が終了した時
     * @internal
     */
    a(this, "RESIZE_DELAY", 510);
    /**
     * ページトランジションの初期化時
     * @internal
     */
    a(this, "T_INIT", 610);
    /**
     * ページトランジションの開始時
     * @internal
     */
    a(this, "T_BEGIN", 620);
    /**
     * 次のページのDOMが挿入される前
     * @internal
     */
    a(this, "T_NEXT_DOM_BEFORE", 630);
    /**
     * 次のページのDOMにアクセス可能な状態
     * @internal
     */
    a(this, "T_BOTH_DOM_EXIST", 640);
    /**
     * 次のページのOBがアクセス可能な状態
     * @internal
     */
    a(this, "T_BOTH_OB_EXIST", 650);
    /**
     * トランジション終了時
     * @internal
     */
    a(this, "T_END", 660);
    /**
     * トランジションでエラーが出た時
     * @internal
     */
    a(this, "T_ERROR", 670);
    /**
     * ライブラリ内でエラーが発生した時
     * @internal
     */
    a(this, "ERROR", 9999);
  }
}
const dt = new vt();
var S;
class Jt extends vt {
  constructor() {
    super();
    d(this, S, {});
    Object.values(dt).forEach((t) => {
      o(this, S)[t] = [];
    });
  }
  checkHookExists(t) {
    if (!Object.values(dt).includes(t))
      throw new Error("フックTYPEが不正です。");
  }
  /**
   * フックの実行を行います。各引数の詳細は {@link Hook.on} を参照してください。
   * @param hook フックタイプ
   * @param state フックに登録したコールバック関数の引数に渡る値
   * @param option フックオプション
   */
  async trigger(t, s, i = {}) {
    const { type: n = "base" } = i;
    this.checkHookExists(t);
    const r = o(this, S)[t];
    for (var l = r.length - 1; l >= 0; l--) {
      const { type: f, once: p, callback: x } = r[l];
      (f === n || f === "base") && (await x(s), p && r.splice(l, 1));
    }
  }
  /**
   * フックに紐づけたい(コールバック)関数の登録を行います。
   * フックに紐づけられた関数は特定の操作、またはイベントが発生したタイミングで実行されます。
   * また、フックを削除したい場合は {@link Hook#off} を使用してください。
   *
   * #### hook
   * フックタイプの種類は以下の通りです。
   *
   * | フックタイプ       | 発火タイミング                                 | コールバックの引数                                                                     |
   * | ----------------- | ---------------------------------------------- | ------------------------------------------------------------------------ |
   * | BEFORE_PAGE_INIT  | {@link Page} モジュールのデフォルト関数実行前                   | {@link Negl}                                                            |
   * | MOUSEMOVE         | マウスが動いている間連続的に発火                  | {@link mouse}                                                            |
   * | MOUSE_MESH_ENTER  | マウスがメッシュに入った時                     | { [mesh](https://threejs.org/docs/#api/en/objects/Mesh), {@link mouse}, {@link Ob ob}, {@link MeshUI meshUI} } |      |
   * | MOUSE_MESH_HOVER  | メッシュにホバーしている時                     | { [mesh](https://threejs.org/docs/#api/en/objects/Mesh), {@link mouse}, {@link Ob ob}, {@link MeshUI meshUI} } |      |
   * | MOUSE_MESH_LEAVE  | マウスがメッシュから出た時                     | { [mesh](https://threejs.org/docs/#api/en/objects/Mesh), {@link mouse}, {@link Ob ob}, {@link MeshUI meshUI} } |      |
   * | MOUSE_MESH_CLICK  | マウスがメッシュをクリックした時               | { [mesh](https://threejs.org/docs/#api/en/objects/Mesh), {@link mouse}, {@link Ob ob}, {@link MeshUI meshUI} } |      |
   * | SCROLL            | スクロールしている時                           | {@link scroller}                                                         |
   * | RENDER            | 毎フレーム（requestAnimationFrame）            | {@link world}                                                            |
   * | RESIZE            | 画面サイズが変わっている間連続的に発火         | {@link viewport}                                                         |
   * | RESIZE_DELAY      | 画面サイズの更新が終了した時                   | {@link viewport}                                                         |
   * | T_INIT            | ページトランジションの初期化時                 | {}*空のオブジェクト                                                        |
   * | T_BEGIN           | ページトランジションの開始時                   | {@link TransitionState state}                                                  |
   * | T_NEXT_DOM_BEFORE | 次のページのDOMが挿入される前                  | {@link TransitionState state}                                                  |
   * | T_BOTH_DOM_EXIST  | 次のページのDOMにアクセス可能な状態            | {@link TransitionState state}                                                  |
   * | T_BOTH_OB_EXIST   | 次のページのObオブジェクトがアクセス可能な状態 | {@link TransitionState state}                                                  |
   * | T_END             | ページトランジション終了時                     | {@link TransitionState state}                                                  |
   * | T_ERROR           | ページトランジションでエラーが出た時           | {@link TransitionState state}                                                  |
   * | ERROR             | negl 内でエラーが発生した時                    | Errorオブジェクト                                                         |
   *
   * #### callback
   * フックに登録したコールバック関数がイベント発火のタイミングで実行されます。
   *
   * #### option
   * オプションはオブジェクトで渡します。以下のプロパティが設定可能です。
   *
   * | プロパティ | 型      | 初期値 | 役割                                                                                                 |
   * | ---------- | ------- | ------ | ---------------------------------------------------------------------------------------------------- |
   * | type       | string  | base   | トランジションのタイプを設定します。（T_*から始まるフックでのみ使用）                                |
   * | priority   | number  | 0      | 同じ種類のフックに複数のコールバックが登録された場合に、priorityが大きい順番でフックが実行されます。 |
   * | once       | boolean | false  | trueの場合、一度実行されたフックは自動的に削除されます。                                             |
   *
   * **使用例**
   * ```ts copy
   * import { hook } from "negl";
   *
   * // マウスがメッシュに入った時に一回発火（
   * hook.on(hook.BEFORE_PAGE_INIT, (negl) => {
   *    console.log(negl); // neglをログに出力
   * })
   * // マウスがメッシュに入った時に一回発火（HTMLタグに`data-interactive`を要付与）
   * hook.on(hook.MOUSE_MESH_ENTER, ({ mouse }) => {
   *    console.log(mouse.getClipPos()); // マウス位置をクリップ座標でログに出力
   * })
   *
   * // マウスがメッシュに入った時に一回発火（HTMLタグに`data-interactive`を要付与）
   * hook.on(hook.MOUSE_MESH_ENTER, ({ mesh }) => {
   *    mesh.scale.set(2,2,1); // マウスが重なった `mesh` をx,y軸方向に2倍に拡大
   * })
   *
   * // マウスがメッシュから出た時に一回発火（HTMLタグに`data-interactive`を要付与）
   * hook.on(hook.MOUSE_MESH_LEAVE, ({ mesh }) => {
   *    mesh.scale.set(1,1,1); // マウスが出た `mesh` を元の大きさに戻す
   * });
   *
   * // マウスをクリックした時に発火（HTMLタグに`data-interactive`を要付与）
   * hook.on(hook.MOUSE_MESH_CLICK, ({ mesh }) => {
   *    // クリックしたメッシュを右方向に 100 移動
   *    mesh.position.x += 100;
   * });
   *
   * // 注意） MOUSE_MESH_* のフックはHTMLタグに`data-interactive`を付与してください。
   * // <img data-webgl="some-effect" data-tex-1="/example.jpg" data-interactive />
   *
   * // スクロール中に発火
   * hook.on(hook.SCROLL, scroller => {
   *    const { delta } = scroller;
   *    console.log(delta.x, delta.y); // スクロールの変化量をログに出力
   * });
   *
   * // 毎フレームの処理
   * hook.on(hook.RENDER, world => {
   *    // 注意）`requestAnimationFrame` のタイミングで連続的に実行されます。
   *    // 重い処理は書かないでください。
   *    console.log(world.tick); // tickのカウントをログに表示
   * });
   *
   * // 画面リサイズ時に連続的に発火
   * hook.on(hook.RESIZE, viewport => {
   *    console.log(viewport.width); // canvasの横幅を取得
   * });
   *
   * // 画面リサイズの終了時に発火
   * hook.on(hook.RESIZE_DELAY, viewport => {
   *    console.log(viewport.width); // canvasの横幅を取得
   * });
   * ```
   * ページトランジション(T_*)に関するフックの使い方については {@link transition} を参照してください。
   */
  on(t, s, i = {}) {
    const { type: n = "base", priority: r = 0, once: l = !1 } = i;
    this.checkHookExists(t);
    const f = { callback: s, type: n, priority: r, once: l };
    o(this, S)[t].push(f), o(this, S)[t].sort((p, x) => p.priority - x.priority);
  }
  /**
   * {@link Hook#on}でフックに登録したコールバックを削除します。
   *
   * ```ts
   * // コールバック関数
   * function logTick(world) {
   *   console.log(world.tick);
   * }
   *
   * // hook.RENDERのフックにコールバック（logTick）を登録
   * hook.on(hook.RENDER, logTick);
   *
   * setTimeout(() => {
   *   // hook.RENDERのフックからコールバック（logTick）を削除
   *   hook.off(hook.RENDER, logTick);
   * }, 3000); // 3秒後
   *
   * // 3秒間`tick`の値がログに出力される。
   * ```
   */
  off(t, s, i = {}) {
    this.checkHookExists(t);
    const n = o(this, S)[t].findIndex(
      (r) => r.callback === s
    );
    n === -1 && (h.debug && console.warn(
      "hook.offが呼ばれましたが、一致するフックが見つかりませんでした。"
    ), h.debug && console.warn("hook:", t), h.debug && console.warn("削除対象のコールバック:", s), h.debug && console.warn(
      "登録されているコールバック一覧",
      o(this, S)[t].map((r) => r.callback)
    ), h.debug && console.warn(
      "登録されているコールバック一覧に削除対象のコールバックが含まれていない場合は既に削除されている可能性があります。"
    )), o(this, S)[t].splice(n, 1);
  }
}
S = new WeakMap();
const c = new Jt(), es = new jt();
var se, ie, re, xe, yt, Te, xt, be, Tt, Oe, bt;
class ts {
  constructor() {
    /**
     * 画像読み込み用メソッド
     * @param url
     * @returns {Texture}
     */
    d(this, xe);
    /**
     * 動画読み込み用メソッド
     * @param url
     * @returns {VideoTexture}
     */
    d(this, Te);
    /**
     * 読み込み対象アセット数を１追加
     */
    d(this, be);
    /**
     * 読み込み完了アセット数を１追加
     */
    d(this, Oe);
    /**
     * 全てのアセットの読み込みが完了している場合 `true`, それ以外 `false`
     * @defaultValue `false`
     */
    a(this, "isLoaded", !1);
    /**
     * URLとそれに紐づくアセットから生成したテクスチャのマッピングを保持します。もし、URLでアセットが取得できなかった場合は`undefined`が格納されます。
     */
    a(this, "textureCache", /* @__PURE__ */ new Map());
    /**
     * 読み込み対象数
     */
    d(this, se, 0);
    /**
     * 読み込み完了数
     */
    d(this, ie, 0);
    d(this, re, () => {
    });
  }
  async loadAllAssets() {
    const e = [], t = g.qsAll(`[data-${h.prefix.ob}]`);
    for (const s of t) {
      const i = s.dataset;
      for (let n in i) {
        if (!n.startsWith(h.prefix.tex))
          continue;
        const r = i[n];
        if (!this.textureCache.has(r)) {
          this.textureCache.set(r, void 0);
          const l = this.loadTex(r);
          e.push(l);
        }
      }
    }
    await Promise.all(e), this.isLoaded = !0;
  }
  /**
   * HTMLに紐づくテクスチャを取得
   *
   * ```ts
   * const texes = await loader.getTexByElement(el);
   * ```
   * @param el HTML要素
   * @returns HTML要素に紐付く全てのテクスチャ
   */
  async getTexByElement(e) {
    const t = /* @__PURE__ */ new Map(), s = e.dataset;
    let i = Promise.resolve(), n = !0;
    for (let r in s) {
      if (!r.startsWith(h.prefix.tex))
        continue;
      const l = s[r];
      let f;
      this.textureCache.has(l) ? f = this.textureCache.get(l) : f = await this.loadTex(l), r = r.replace("-", ""), t.set(r, f), n && e instanceof HTMLImageElement && (i = new Promise((p) => {
        e.onload = p;
      }), e.src = l, n = !1), n && e instanceof HTMLVideoElement && (i = new Promise((p) => {
        e.onloadeddata = p;
      }), e.src = l, e.load(), n = !1);
    }
    return await i, t;
  }
  /**
   * `url`に設定されたアセット（画像、動画）の読み込み、テクスチャを返却します。
   *
   * ```ts copy
   * const tex = await loader.loadTex('/img/sample.jpg');
   * ```
   * @param url
   * @returns
   */
  async loadTex(e) {
    if (this.textureCache.has(e) && this.textureCache.get(e))
      return this.textureCache.get(e);
    const t = /\.(mp4|webm|mov)$/.test(e) ? w(this, Te, xt) : w(this, xe, yt);
    return w(this, be, Tt).call(this), t(e).then((s) => (this.textureCache.set(e, s), s)).catch(() => {
      console.error("Media Download Error:", e);
    }).finally(() => {
      w(this, Oe, bt).call(this);
    });
  }
  /**
   * 読み込み進捗表示の関数追加メソッド
   * @internal
   */
  addProgressAction(e) {
    E(this, re, e);
  }
}
se = new WeakMap(), ie = new WeakMap(), re = new WeakMap(), xe = new WeakSet(), yt = async function(e) {
  try {
    const t = await es.loadAsync(e);
    return t.magFilter = ge, t.minFilter = ge, t.needsUpdate = !1, t;
  } catch {
    throw new Error();
  }
}, Te = new WeakSet(), xt = async function(e) {
  const t = g.htmlToEl("<video></video>");
  let s = e.split(".").pop();
  if (s === "mov" && (s = "quicktime"), !!t.canPlayType(`video/${s}`))
    return t.remove(), new Promise((i, n) => {
      const r = g.htmlToEl(`<video
    autoplay
    loop
    muted
    playsinline
    defaultMuted
    crossorigin="anonymous"
    ></video>`);
      r.oncanplay = () => {
        const l = new Ft(r);
        l.magFilter = ge, l.minFilter = ge, r.play(), r.oncanplay = null, i(l);
      }, r.onerror = () => {
        n();
      }, r.src = e;
    });
}, be = new WeakSet(), Tt = function() {
  Be(this, se)._++;
}, Oe = new WeakSet(), bt = function() {
  var e;
  Be(this, ie)._++, (e = o(this, re)) == null || e.call(this, o(this, ie), o(this, se));
};
const te = new ts();
class Ze {
  constructor({ texes: e, el: t, type: s }) {
    /**
     * DOM要素を保持するためのプロパティです。
     * $.elにはエフェクトが紐づくDOM要素が格納されます。
     */
    a(this, "$");
    /**
     * trueの時、キャッシュから取得されたオブジェクト。falseの時、それ以外。
     */
    a(this, "isCache", !1);
    /**
     * テクスチャマップ
     */
    a(this, "texes");
    /**
     * DOM要素のdataset（data-*のキーと値が格納されているオブジェクト）のコピーを保持します。
     */
    a(this, "dataAttrs");
    /**
     * メッシュのスケールを保持します。これは画面の初期表示時からどれだけメッシュが伸縮しているかを数値で保持します。メッシュのスケールを変更した際はこのプロパティの値も変更してください。
     */
    a(this, "scale");
    /**
     * リサイズフラグ
     * リサイズ処理を実行中は `true`、それ以外 `false`。
     */
    a(this, "resizing");
    /**
     * fixed フラグ
     * `true` スクロールによるエフェクトの追従を自動で行います。`false`、スクロールに追従しません。
     */
    a(this, "fixed");
    /**
     * $.el プロパティに格納されたDOM要素の [DOMRect](https://developer.mozilla.org/ja/docs/Web/API/DOMRect) の状態を保持します。画面幅が更新されるたびに最新の DOMRect で更新されます。
     */
    a(this, "rect");
    /**
     * $.elプロパティに格納されたDOM要素のの画面初期表示時の [DOMRect](https://developer.mozilla.org/ja/docs/Web/API/DOMRect) を保持します。
     */
    a(this, "originalRect");
    /**
     * {@link https://threejs.org/docs/?q=ShaderMa#api/en/materials/ShaderMaterial.defines ShaderMaterial#defines}オブジェクト
     * {@link setupDefines} の戻り値が設定されます。
     */
    a(this, "defines", {});
    /**
     * {@link https://threejs.org/docs/?q=ShaderMa#api/en/materials/ShaderMaterial.uniforms ShaderMaterial#uniforms}オブジェクト
     * {@link setupUniforms} の戻り値が設定されます。
     */
    a(this, "uniforms", {});
    /**
     * {@link https://threejs.org/docs/?q=ShaderMa#api/en/materials/ShaderMaterial.vertexShader ShaderMaterial#vertexShader}文字列
     * {@link setupVertex} の戻り値が設定されます。
     */
    a(this, "vertexShader", "");
    /**
     * {@link https://threejs.org/docs/?q=ShaderMa#api/en/materials/ShaderMaterial.fragmentShader ShaderMaterial#fragmentShader}文字列
     * {@link setupFragment} の戻り値が設定されます。
     */
    a(this, "fragmentShader", "");
    /**
     * {@link https://threejs.org/docs/?q=Material#api/en/materials/Material Material}オブジェクト
     * {@link setupMaterial} の戻り値が設定されます。
     *
     */
    a(this, "material");
    /**
     * {@link https://threejs.org/docs/?q=BufferGeometry#api/en/core/BufferGeometry Geometry}オブジェクト
     * {@link setupGeometry} の戻り値が設定されます。
     */
    a(this, "geometry");
    /**
     * {@link https://threejs.org/docs/?q=Object#api/en/core/Object3D Mesh}オブジェクト
     * {@link setupMesh} の戻り値が設定されます。
     */
    a(this, "mesh");
    /**
     * マウスホバー中の{@link https://threejs.org/docs/?q=Object#api/en/core/Object3D Mesh}オブジェクト
     */
    a(this, "hoveringMesh");
    // /**
    //  * {@link https://threejs.org/docs/?q=Layers#api/en/core/Layers Layers}に
    //  */
    // layers: number[];
    /**
     * 現在のスクロール位置をワールド座標で保持します。
     * * 横方向のスクロールは現状対応していません。
     */
    a(this, "scrollPos", { x: 0, y: 0 });
    var i;
    if (this.$ = { el: t }, this.texes = e ?? /* @__PURE__ */ new Map(), this.dataAttrs = { ...t.dataset }, this.scale = { width: 1, height: 1, depth: 1 }, this.resizing = !1, this.fixed = !1, this.rect = this.originalRect = g.getRect(t), (!this.rect.width || !this.rect.height) && h.debug)
      throw new Error(
        `要素に1px x 1px以上の大きさがないため、メッシュの作成をスキップします:${this.$.el.toString()}`
      );
    this.beforeCreateMesh(), this.defines = this.setupDefines(), this.uniforms = this.setupUniforms(), this.uniforms = this.setupTexes(this.uniforms), (i = this.uniforms) != null && i.uResolution && (this.uniforms.uResolution.hasOwnProperty("value") || (this.uniforms.uResolution = { value: null }), this.uniforms.uResolution.value = this.getResolution()), this.vertexShader = this.setupVertex(), this.fragmentShader = this.setupFragment(), this.material = this.setupMaterial(), this.geometry = this.setupGeometry(), this.mesh = this.setupMesh(), this.disableOriginalElem(), this.mesh.userData.marker = s, this.mesh.visible = !1;
  }
  /**
   * Obクラスの初期化用静的メソッドです。
   *
   * Obクラス内で使用するテクスチャはtexesの変数としてObクラスのコンストラクタに渡していますが、テクスチャの取得は非同期処理トなるため、コンストラクタ関数内に記述することは出来ません。その為、この静的メソッド内でOb内で使用するテクスチャを取得し、インスタンス化を行っています。Obクラスのinit関数の実装は以下の通りです。
   *
   * ```ts
   * static async init({ el, type }: { el: HTMLElement; type: string }): Promise<Ob> {
   *  const texes = await loader.getTexByElement(el); // テスクチャを取得
   *  const o = new this({ texes, el, type });        // インスタンス化
   *  return o;                                       // インスタンスを返却
   * }
   * ```
   *
   */
  static async init({
    el: e,
    type: t
  }) {
    const s = await te.getTexByElement(e);
    return new this({ texes: s, el: e, type: t });
  }
  /**
   * メッシュの作成前に実行する処理を記載します。
   */
  beforeCreateMesh() {
  }
  /**
   * 戻り値が ShaderMaterial.define に使用されます。
   *
   * 初期状態ではPIを返却します。
   * ```js
   * { PI: Math.PI }
   * ```
   * @returns
   */
  setupDefines() {
    return {
      PI: Math.PI
    };
  }
  /**
   * 戻り値がShaderMaterial.uniformsに使用されます。
   * 初期状態では {@link DefaultUniforms} が返却されます。
   * @returns
   */
  setupUniforms() {
    return {
      uTick: { value: 0 },
      uMouse: { value: new We(0.5, 0.5) },
      uHover: { value: 0 },
      uProgress: { value: 0 },
      uAlpha: { value: 0 },
      uResolution: { value: new Ge() }
    };
  }
  /**
   * ShaderMaterialの uniforms に設定する値を返却します。（テクスチャ用）
   * @param uniforms
   * @returns
   */
  setupTexes(e) {
    var t;
    return (t = this.texes) == null || t.forEach((s, i) => {
      const n = i.replace(h.prefix.tex, "");
      e["tex" + n] = { value: s };
    }), e;
  }
  /**
   * ジオメトリを返却します。
   * 初期状態ではPlaneGeometryを返却します。
   *
   * ```js
   * new PlaneGeometry(this.rect.width, this.rect.height, 1, 1);
   * ```
   */
  setupGeometry() {
    return new Vt(this.rect.width, this.rect.height, 1, 1);
  }
  /**
   * マテリアルを返却します。
   * 初期状態では ShaderMaterial を返却します。
   *
   * ```js
   * const material = new ShaderMaterial({
   * defines: this.defines,
   *   vertexShader: this.vertexShader,
   *   fragmentShader: this.fragmentShader,
   *   uniforms: this.uniforms,
   *   transparent: true,
   * });
   * material.onBeforeCompile = this.onBeforeCompile;
   * return material;
   * ```
   */
  setupMaterial() {
    const e = new ft({
      defines: this.defines,
      vertexShader: this.vertexShader,
      fragmentShader: this.fragmentShader,
      uniforms: this.uniforms,
      transparent: !0,
      alphaTest: 0.5
    });
    return e.onBeforeCompile = this.onBeforeCompile, e;
  }
  /**
     * シェーダのコンパイル前にシェーダコードを変更します。
     * Obクラスではシェーダの texture を texture2D に変換する以下のコードを記述しています。
     *
     * ```ts
      if (shader.isWebGL2) return; // WebGL 2.0の場合、変更は不要
  
      // WebGL1.0の場合はtexture関数が見つからないため、texture2Dにシェーダのコードを置換
      shader.vertexShader = shader.vertexShader.replace(/texture\(/g, "texture2D(");
      shader.fragmentShader = shader.fragmentShader.replace(/texture\(/g, "texture2D(");
     * ```
     */
  onBeforeCompile(e) {
    e.isWebGL2 || (e.vertexShader = e.vertexShader.replace(
      /texture\(/g,
      "texture2D("
    ), e.fragmentShader = e.fragmentShader.replace(
      /texture\(/g,
      "texture2D("
    ));
  }
  /**
   * ShaderMaterialに設定するVertexShaderシェーダを返却します。
   * オーバーライドして使用してください。シェーダを使用しないマテリアル（例えば、MeshStandardMaterial）の場合は空のメソッドでオーバーライドしてください。
   *
   * **シェーダを使わない場合は何も返却しないメソッドを定義してください。**
   * ```js
   * setupVertex(): FragmentShader {
   *  return;
   * }
   * ```
   */
  setupVertex() {
    throw new Error("このメソッドはオーバーライドして使用してください。");
  }
  /**
   * ShaderMaterialに設定するfragmentシェーダを返却します。
   * オーバーライドして使用してください。シェーダを使用しないマテリアル（例えば、MeshStandardMaterial）の場合は空のメソッドでオーバーライドしてください。
   *
   * **シェーダを使わない場合は何も返却しないメソッドを定義してください。**
   * ```js
   * setupFragment(): FragmentShader {
   *  return;
   * }
   * ```
   */
  setupFragment() {
    throw new Error("このメソッドはオーバーライドして使用してください。");
  }
  /**
   * テクスチャとHTML要素の大きさのアスペクト比からuResolutionを設定します。
   * @param {DOMRect} rect 要素の矩形を渡します。省略された場合はthis.rectが使用されます。
   * @param {HTMLImageElement | HTMLVideoElement} mediaElement 画像、または動画。省略した場合はdata-tex-1に設定されたメディアが使用されます。
   * @returns {Vector4} uResolutionに設定するVector4オブジェクト
   * x: DOMの横幅
   * y: DOMの縦幅
   * z: 横幅に掛ける縦横比
   * w: 縦幅に掛ける縦横比
   */
  getResolution(e, t) {
    var r, l;
    const s = t ?? ((l = (r = this.texes.get(h.prefix.tex + 1)) == null ? void 0 : r.source) == null ? void 0 : l.data);
    if (!s)
      return new Ge();
    const i = { width: 0, height: 0 };
    return s instanceof HTMLImageElement ? (i.width = s.naturalWidth, i.height = s.naturalHeight) : s instanceof HTMLVideoElement && (i.width = s.videoWidth, i.height = s.videoHeight), y.getResolutionUniform(e ?? this.rect, i);
  }
  /**
   * 返却されたメッシュがthis.meshに設定されます。
   * @returns
   */
  setupMesh() {
    return new Gt(this.geometry, this.material);
  }
  /**
   * Layersを設定します。
   * @param layers
   */
  // setLayers(...layers: number[]) {
  //   this.layers = layers.length > 0 ? layers : this.layers;
  //   this.#setLayerRecursively(this.mesh, this.layers);
  // }
  // #setLayerRecursively(mesh: Object3D, layers: number[]) {
  //   layers.forEach(layer => mesh.layers.enable(layer));
  //   // mesh.layers.set(layers);
  //   mesh.children.forEach((mesh: Object3D) => this.#setLayerRecursively(mesh, layers));
  // }
  /**
   * Obの元になったHTML要素の画面から除外します。
   * 処理内容は以下の通りです。
   * ```js
   * disableOriginalElem(): void {
   *   this.$.el.draggable = false;
   *   this.$.el.style.opacity = "0";
   * }
   * ```
   */
  disableOriginalElem() {
    this.$.el.draggable = !1, this.$.el.style.opacity = "0";
  }
  /**
   * 画面幅の変更に伴うエフェクトの位置や大きさの変更を行います。
   * 処理内容は以下の通りです。
   *
   * ```ts
   * async resize(duration: number = 1): Promise<void> {
   *   this.resizing = true;
   *
   *   const {
   *     $: { el },
   *     mesh,
   *     originalRect,
   *   } = this;
   *
   *   const nextRect = INode.getRect(el)!;
   *   const { x, y } = this.getWorldPosition(nextRect, viewport);
   *
   *   if (mesh === undefined) return;
   *
   *   const p1 = new Promise((onComplete) => {
   *     // utils.tween については{@link utils.tween こちら}を参照
   *     utils.tween(mesh.position, {
   *       x,
   *       y,
   *       duration,
   *       onComplete,
   *     })
   *   });
   *
   *   // 大きさの変更
   *   const p2 = new Promise((onComplete) => {
   *     utils.tween(this.scale, {
   *       width: nextRect.width / originalRect.width,
   *       height: nextRect.height / originalRect.height,
   *       depth: 1,
   *       duration,
   *       onUpdate: () => {
   *         mesh.scale.set(this.scale.width, this.scale.height, this.scale.depth);
   *       },
   *       onComplete
   *     })
   *   });
   *
   *   const p3 = new Promise((onComplete) => {
   *     if (!this.uniforms?.uResolution) return onComplete(null);
   *     const resolution = this.getResolution(nextRect);
   *     utils.tween(this.uniforms.uResolution.value, {
   *       x: resolution.x,
   *       y: resolution.y,
   *       z: resolution.z,
   *       w: resolution.w,
   *       duration,
   *       onComplete,
   *     })
   *   });
   *
   *   await Promise.all([p1, p2, p3]);
   *
   *   this.rect = nextRect;
   *
   *   this.resizing = false;
   * }
   * ```
   *
   * @param duration {@link config} の　`viewport.resizeDuration` の値が渡ってきます。
   * @returns
   */
  async resize(e = 1) {
    this.resizing = !0;
    const {
      $: { el: t },
      mesh: s,
      originalRect: i
    } = this, n = g.getRect(t), { x: r, y: l } = this.getWorldPosition(n, b);
    if (s === void 0)
      return;
    const f = new Promise((m) => {
      y.tween(s.position, {
        x: r,
        y: l,
        duration: e,
        onComplete: m
      });
    }), p = new Promise((m) => {
      y.tween(this.scale, {
        width: n.width / i.width,
        height: n.height / i.height,
        depth: 1,
        duration: e,
        onUpdate: () => {
          s.scale.set(this.scale.width, this.scale.height, this.scale.depth);
        },
        onComplete: m
      });
    }), x = new Promise((m) => {
      var $;
      if (!(($ = this.uniforms) != null && $.uResolution))
        return m(null);
      const M = this.getResolution(n);
      y.tween(this.uniforms.uResolution.value, {
        x: M.x,
        y: M.y,
        z: M.z,
        w: M.w,
        duration: e,
        onComplete: m
      });
    });
    await Promise.all([f, p, x]), this.rect = n, this.resizing = !1;
  }
  /**
   * HTMLの座標からワールド座標の位置を取得します。
   * @param duration
   * @returns
   */
  getWorldPosition(e, t) {
    return y.getWorldPosition(e, t);
  }
  /**
   * スクロールに伴うメッシュの位置情報を変更します。
   * @param duration
   * @returns
   */
  scroll() {
    if (this.fixed)
      return;
    const {
      $: { el: e },
      mesh: t
    } = this, s = g.getRect(e), { x: i, y: n } = this.getWorldPosition(s, b);
    t !== void 0 && (this.scrollPos.y = t.position.y = y.lerp(
      this.scrollPos.y,
      n,
      h.scroller.damping
    ));
  }
  /**
   * フレーム毎に実行したい処理を記述します。
   */
  render(e, t) {
    var s;
    (s = this.uniforms) != null && s.uTick && (this.uniforms.uTick.value = e);
  }
  /**
   * Obオブジェクトの作成後に実行します。
   */
  afterInit() {
  }
  /**
   * 動画テクスチャを再生します。
   */
  async playVideo(e = `${h.prefix.tex}1`) {
    var t, s;
    (s = (t = this.uniforms[e].value.source.data).play) == null || s.call(t);
  }
  /**
   * 動画テクスチャを停止します。
   */
  pauseVideo(e = `${h.prefix.tex}1`) {
    var t, s;
    (s = (t = this.uniforms[e].value.source.data).pause) == null || s.call(t);
  }
  /**
   * 戻り値で返却した`data-click-*`のアクションを実行します。例えば、getClickIdxで `1` を返却するように実装すると `data-click-1` の値に設定されたアクションが実行されます。実装を上書きしない場合は `1` が返ります。
   *
   * なお、`data-click-*`の使い方については [data-click](/reference/html/#data-click-) を参照してください。
   *
   * ```html copy
   * <!-- URL任意のURLに画面遷移。例）`1`を返却。`/detail.html`への画面遷移 -->
   * <!-- 別タブで画面を開く。例）`2`を返却。`/detail.html`を別タブで開く -->
   * <!-- `3`が返却された場合は`data-click-3`に設定されたObクラスのメソッド`goNext`を実行 -->
   * <div data-webgl="some-effect"
   *      data-interactive
   *      data-click-1="/detail.html"
   *      data-click-2="newTab,/detail.html"
   *      data-click-3="goNext"
   * ></div>
   * ```
   */
  getClickIdx() {
    return 1;
  }
  /**
   * メッシュクリック時の挙動を制御します。
   *
   * Obクラスでは次のフローで click 時の挙動を制御しています。もし、メッシュクリック時の挙動を変更したい場合はこのメソッドをオーバーライドしてください。
   *
   * **Ob クラスの click イベントの制御**
   *
   * 1. {@link getClickIdx} の戻り値により `data-click-*` の値を取得します。
   * 2. `data-click-*` に設定されている値が
   *    - クラスに存在するメソッドだった場合
   *      -> そのメソッドを実行します。
   *
   *    - URL、もしくは newTab から始まる文字列だった場合
   *      -> ページ遷移を行います。
   */
  click({
    meshUI: e,
    event: t,
    transition: s
  }) {
    const i = this.getClickIdx(), n = this.dataAttrs[`${h.prefix.click}-${i}`];
    if (n === void 0) {
      console.error(
        `data-${h.prefix.click}-${i}にアクションが登録されていません。`
      );
      return;
    }
    const [r, ...l] = n.split(",");
    typeof this[r] == "function" ? this[r](l, { meshUI: e, event: t, transition: s }) : this.link([r, ...l], { meshUI: e, event: t, transition: s });
  }
  link(e, t) {
    const { href: s, target: i } = y.getHrefObj(e), n = this.dataAttrs[h.prefix.transition];
    t.transition.goTo({
      href: s,
      target: i,
      mesh: this.hoveringMesh,
      triggerType: "mesh",
      event,
      type: n
    });
  }
}
let we;
var G, Me, Ot, Re, Mt, Pe, Rt, Ie, Pt;
const ot = class ot {
  constructor() {
    d(this, Me);
    d(this, Re);
    d(this, Pe);
    d(this, Ie);
    /**
     * アニメーション用のマウス座標が存在する位置を保持します。
     * 
     * **[アニメーション用のマウス座標]**  
     * mouse オブジェクトではブラウザのデフォルトのマウスカーソルから少し遅れた位置を current に保持しています。これによって、マウスに追従する独自のスタイルを実装することができます。どの程度遅延させるかは [config.mouse.speed](/reference/interfaces/Config/#マウスに関する設定) プロパティで設定します。
     */
    a(this, "current", {});
    /**
     * ブラウザのマウスカーソルの存在する位置を保持します。
     */
    a(this, "target", {});
    /**
     * ブラウザのマウスカーソル位置にアニメーション用のマウス座標の位置の変化量を保持します。
     */
    a(this, "delta", {});
    /**
     * マウスカーソルの初期値を保持します。
     */
    a(this, "initial", {});
    /**
     * マウスの位置が更新された回数を保持します。
     */
    a(this, "tick", 0);
    /**
     * マウスのアニメーション座標をブラウザのデフォルトのカーソル位置にどの程度の速度で追従させるかを数値で保持します。  
     * [config.mouse.speed](/reference/interfaces/Config/#マウスに関する設定) プロパティに設定された値がこのプロパティに設定されます。
     */
    a(this, "speed", h.mouse.speed);
    d(this, G, !0);
    const e = {
      x: b.width / 2,
      y: b.height / 2
    };
    Object.assign(this.current, e), Object.assign(this.target, e), Object.assign(this.delta, e), this.initial = e, this.current = this.current, this.target = this.target, this.delta = this.delta, w(this, Ie, Pt).call(this);
  }
  static init() {
    return we || (we = new ot()), we;
  }
  /**
   * マウス位置をクリップ座標で返します。
   * @returns 
   */
  getClipPos() {
    return {
      x: this.current.x / b.width * 2 - 1,
      y: -(this.current.y / b.height) * 2 + 1
    };
  }
  /**
   * マウス位置をUV座標で返します。
   * @returns 
   */
  getUvPos() {
    const e = this.getClipPos();
    return {
      x: e.x / 2 + 0.5,
      y: e.y / 2 + 0.5
    };
  }
  /**
   * マウス位置を画面中央を0とした際の任意のスケールの座標で返します。
   * @returns 
   */
  getMapPos(e, t) {
    const s = this.getClipPos();
    return {
      x: s.x * e / 2,
      y: s.y * t / 2
    };
  }
  reset() {
    this.startTrackMousePos();
  }
  /**
   * newTarget のプロパティを {@link Mouse.target} オブジェクトに上書きします。
   * @param newTarget 
   */
  setTarget(e) {
    Object.assign(this.target, e);
  }
  /**
   * マウスの座標の更新をスタートする際に使用します。
   */
  startTrackMousePos() {
    E(this, G, !0);
  }
  /**
   * マウス座標の更新をストップする際に使用します。
   */
  stopTrackMousePos() {
    E(this, G, !1);
  }
  /**
   * マウス座標が前回の位置から変更されている場合は `true`、それ以外は `false` を返します。
   * @returns 
   */
  isUpdate() {
    return Math.abs(this.current.x - this.target.x) > 1e-4 || Math.abs(this.current.y - this.target.y) > 1e-4;
  }
};
G = new WeakMap(), Me = new WeakSet(), Ot = function() {
  this.delta.x = this.target.x - this.current.x, this.delta.y = this.target.y - this.current.y, this.current.x += this.delta.x * this.speed, this.current.y += this.delta.y * this.speed;
}, Re = new WeakSet(), Mt = function(e) {
  this.target.x = e.clientX, this.target.y = e.clientY, this.tick++;
}, Pe = new WeakSet(), Rt = function() {
  y.isTouchDevices() || w(this, Me, Ot).call(this);
}, Ie = new WeakSet(), Pt = function() {
  const e = g.getElement(h.$.globalContainer), t = (s) => {
    if (o(this, G)) {
      const i = s instanceof MouseEvent ? s : s.touches[0];
      w(this, Re, Mt).call(this, i);
    }
    c.trigger(c.MOUSEMOVE, this);
  };
  y.isTouchDevices() ? e.addEventListener("touchstart", t) : e.addEventListener("mousemove", t), c.on(c.RENDER, () => {
    w(this, Pe, Rt).call(this);
  });
};
let ve = ot, F;
var ne, Se, Ce, It, oe, Xe;
class ss {
  constructor() {
    d(this, Ce);
    d(this, oe);
    d(this, ne, void 0);
    d(this, Se, () => {
      this.scrolling = !1;
    });
    /**
     * スクロール中の時は `true`、それ以外は `false` が設定されます。
     */
    a(this, "scrolling", !1);
    /**
     * スクロールの変化量が渡ります。
     *
     * スクロールに合わせてスクロールの変化量を取得したい場合は {@link Hook.on hook.on} の SCROLL タイプで取得してください。
     *
     * ```js
     * hook.on(hook.SCROLL, (scroller) => {
     *   console.log(scroller.delta);
     *   // スクロール中はスクロールの変化量がログに出力されます。
     * })
     * ```
     */
    a(this, "delta", { x: 0, y: 0 });
    a(this, "deltaTmp", { x: 0, y: 0 });
    a(this, "onScroll", () => {
      this.scrolling = !0, clearTimeout(o(this, ne)), E(this, ne, window.setTimeout(o(this, Se), 50));
    });
    w(this, Ce, It).call(this);
  }
  static init() {
    return F || (F = new this()), F;
  }
  setDelta(e) {
    this.deltaTmp.x = y.lerp(this.delta.x, e.x, 0.3), this.deltaTmp.y = y.lerp(this.delta.y, e.y, 0.3);
  }
  /**
   * スクロールを無効化します。（スクロールできないようになります。）
   */
  disable() {
    window.addEventListener("wheel", w(this, oe, Xe), { passive: !1 });
  }
  /**
   * スクロールを有効化します。（スクロールできるようになります。）
   */
  enable() {
    window.removeEventListener("wheel", w(this, oe, Xe), {
      passive: !1
    });
  }
  /**
   * [scrollIntoView](https://developer.mozilla.org/ja/docs/Web/API/Element/scrollIntoView) メソッドと同等の機能を持ちます。
   * scrollIntoView() が呼び出された要素がユーザーに見えるところまで、要素の親コンテナーをスクロールします。
   * @param el
   * @param scrollIntoViewOptions [scrollIntoViewOptions](https://developer.mozilla.org/ja/docs/Web/API/Element/scrollIntoView)
   * ただし、behavior オプションは "auto" のみ許容します。
   */
  async scrollIntoView(e, t) {
    e && e.scrollIntoView(t);
    const s = h.scroller.damping;
    h.scroller.damping = 1, await c.trigger(c.SCROLL, this), h.scroller.damping = s;
  }
  /**
   * #id までページ内スクロールを行います。
   * @param hash id属性
   */
  scrollToHash(e) {
    const t = g.htmlToEl("<a></a>");
    t.href = e;
    const s = g.qs(t.hash);
    s && this.scrollIntoView(s, { behavior: "auto" });
  }
  /**
   * ページの最上部から px 分スクロールを行います。
   * @param px 画面最上部からスクロールしたい量を px で指定します。
   */
  set scrollTop(e) {
    if (typeof e != "number")
      throw new Error(`this.scrollTopに数値以外が設定されています。値: ${e}`);
    document.documentElement.scrollTop = e, (async () => {
      const t = h.scroller.damping;
      h.scroller.damping = 1, await c.trigger(c.SCROLL, this), h.scroller.damping = t;
    })();
  }
  /**
   * ページの最上部からのスクロール量を数値で取得します。
   * @returns ページの最上部からのスクロール量
   */
  get scrollTop() {
    return document.documentElement.scrollTop;
  }
}
ne = new WeakMap(), Se = new WeakMap(), Ce = new WeakSet(), It = function() {
  if (c.on(c.RENDER, () => {
    this.delta.x = y.lerp(this.deltaTmp.x, 0, 0.3, 1e-5), this.delta.y = y.lerp(this.deltaTmp.y, 0, 0.3, 1e-5), this.deltaTmp.x = this.delta.x, this.deltaTmp.y = this.delta.y, (y.isTouchDevices() || this.delta.x !== 0 || this.delta.y !== 0) && c.trigger(c.SCROLL, F);
  }), y.isTouchDevices()) {
    const t = { x: 0, y: 0 }, s = { x: 0, y: 0 };
    window.addEventListener("touchstart", (i) => {
      t.x = i.touches[0].clientX, t.y = i.touches[0].clientY;
    }), window.addEventListener("touchmove", (i) => {
      const n = {
        x: i.touches[0].clientX,
        y: i.touches[0].clientY
      };
      s.x = n.x - t.x, s.y = n.y - t.y, this.setDelta(s), this.onScroll();
    });
  } else
    window.addEventListener("wheel", (t) => {
      this.setDelta({ x: t.deltaX, y: t.deltaY }), this.onScroll();
    });
}, oe = new WeakSet(), Xe = function(e) {
  e.preventDefault();
};
const ut = {
  data: /* @__PURE__ */ new Map(),
  get(u) {
    if (this.data.has(u))
      return this.data.get(u);
    const e = /* @__PURE__ */ new Map();
    return this.data.set(u, e), e;
  }
}, pe = /* @__PURE__ */ new Map();
let J;
var ae, L, W, U, he, q, De, St, ke, Ct, Ae, Dt;
const I = class I {
  constructor({
    spaMode: e = !1,
    cache: t = !0,
    defaultType: s = ""
  } = {}) {
    d(this, De);
    // リロードしないページトランジションの対象か？
    d(this, ke);
    // 新しいページのドキュメントを取得します
    d(this, Ae);
    a(this, "running", !1);
    a(this, "state");
    d(this, ae, /* @__PURE__ */ new Set());
    d(this, L, void 0);
    d(this, W, void 0);
    d(this, U, window.location.pathname);
    d(this, he, void 0);
    d(this, q, void 0);
    E(this, W, e), E(this, L, t), E(this, he, s), o(this, W) && w(this, De, St).call(this);
  }
  static init(e) {
    return J || (J = new I(e)), J;
  }
  /**
   *
   * @param pathes
   */
  addExcludePath(...e) {
    e.forEach((t) => o(this, ae).add(t));
  }
  popstate(e) {
    const t = window.location.href;
    this.goTo({ href: t, event: e, triggerType: "popstate" });
  }
  /**
   * href として渡されたページに遷移します。
   *
   * @param href 遷移先のURL、またはパス
   * @param target _self の時、現在アクティブのタブでページ遷移を行います。_blank の時、別タブで開きます。
   * @param type トランジションタイプ
   */
  go(e, t, s) {
    this.goTo({ href: e, target: t, triggerType: "link", type: s });
  }
  goTo({ href: e, target: t = "_self", event: s, triggerType: i, mesh: n, type: r }) {
    if (o(this, W))
      switch (w(this, ke, Ct).call(this, e, t, i)) {
        case I.TRANSITION_TYPE.HASH:
          s == null || s.preventDefault(), F.scrollToHash(e);
          break;
        case I.TRANSITION_TYPE.SPA:
          s == null || s.preventDefault(), this.pageTransition({ href: e, event: s, mesh: n, triggerType: i, type: r });
          break;
        case I.TRANSITION_TYPE.NON_SPA:
        default:
          i === "mesh" && window.open(e, t);
          break;
      }
  }
  async pageTransition({
    href: e,
    event: t = {},
    triggerType: s,
    mesh: i,
    type: n
  }) {
    let r = {}, l = n ?? o(this, he);
    l || (h.debug && console.info("トランジションのタイプが指定されていません。"), h.debug && console.info(
      'data-transition="type"、または config.transition.defaultType でトランジションタイプを指定することができます。'
    ));
    try {
      if ((s === "link" || s === "mesh") && history.pushState({}, "", e), this.running)
        throw new Error("トランジション中に画面遷移が発生しました。");
      this.running = !0, this.state = r = {
        current: {
          el: null,
          page: null,
          pageType: null,
          url: o(this, U),
          os: null,
          get store() {
            return ut.get(this.url);
          }
        },
        next: {
          el: null,
          page: null,
          pageType: null,
          url: e,
          os: [],
          head: null,
          doc: null,
          get store() {
            return ut.get(e);
          }
        },
        triggerMesh: i,
        triggerType: s,
        event: t,
        transitionType: l
      };
      const f = r.current.el = g.qs(
        h.$.pageContainer
      ), p = r.current.os = [...R.os];
      r.current.pageType = g.getDS(
        f,
        h.prefix.page
      ), r.current.page = await Ee.get(r.current.pageType), typeof o(this, q) == "function" && (l = await o(this, q).call(this, l, r) ?? l);
      const x = c.trigger(c.T_BEGIN, r, {
        type: l
      });
      let {
        dom: m,
        head: M,
        doc: $
      } = pe.get(e) || {};
      if (!m || !M) {
        const v = r.next.doc = await w(this, Ae, Dt).call(this, e);
        m = r.next.el = g.qs(
          h.$.pageContainer,
          v
        ), M = r.next.head = v.head;
      } else
        h.debug && console.info("Cache HIT!", m, M), r.next.doc = $, r.next.el = m, r.next.head = M, o(this, L) && pe.delete(e);
      r.next.pageType = g.getDS(m, h.prefix.page), await x, await c.trigger(c.T_NEXT_DOM_BEFORE, r, {
        type: l
      });
      const C = [
        ...m.querySelectorAll("img[src], video[src]")
      ].map((v) => new Promise((K) => {
        const D = () => {
          v.removeEventListener("load", D), K();
        };
        v.naturalWidth || v.videoWidth ? K() : v.addEventListener("load", D);
      }));
      f.before(m), await Promise.all(C), r.next.page = await Ee.get(r.next.pageType), await c.trigger(c.T_BOTH_DOM_EXIST, r, {
        type: l
      }), await te.loadAllAssets(), o(this, L) && R.cacheCurrentOs(), B.reset();
      let j = await R.initObs(m);
      const fe = r.next.os = j.filter((v) => v.mesh), N = fe.map(async (v) => {
        await v.resize(0), v.isCache || await v.afterInit(), R.addOb(v);
      });
      await Promise.all(N), B.watchMarks(fe), await c.trigger(c.T_BOTH_OB_EXIST, r, {
        type: l
      }), we.reset(), f.remove(), p.forEach((v) => {
        R.removeOb(v, !o(this, L));
      }), h.debug && (z.destroy(), z.init(), z.addRecommendGUI(R)), o(this, L) && o(this, U) && !pe.has(o(this, U)) && pe.set(o(this, U), {
        dom: f,
        head: document.head.cloneNode(!0)
      }), await c.trigger(c.T_END, r, { type: l }), E(this, U, e);
    } catch (f) {
      if (console.error("ページ遷移実行中にエラーが発生しました。"), console.error(f), await c.trigger(c.T_ERROR, r, { type: l }), h.debug)
        debugger;
      else
        window.location.href = e;
    } finally {
      this.running = !1;
    }
  }
  /**
   * 戻り値で返却されたトランジションタイプでページ遷移が行われます。
   * JSで動的にトランジションタイプを決定したい場合に使用してください。
   *
   * **注意**
   * この処理は T_BEGIN の実行前に実行されます。その為、この時点では次のページの情報は基本的に取得できません。もし、次のページの種類によってトランジションタイプを変えたい場合は次のページの url などから判定してください。
   *
   * ```js
   * transition.changeType((transitionType, state) => {
   *   const { current, next, triggerType } = state;
   *   // 現在ページのページタイプ（data-pageの値）が `home` の時
   *   if (current.pageType === "home") {
   *     return "transition-type-1";
   *   }
   *   // 次のページのURLに detail が含まれていない場合
   *   if (next.url.indexOf("detail") !== -1) {
   *     return "transition-type-2"
   *   }
   *   // ブラウザバックの時
   *   if (triggerType === "popstate") {
   *     return "transition-type-3";
   *   }
   *   // それ以外の時、トランジションタイプを変更しない。
   *   return transitionType;
   * });
   * ```
   *
   * @param callback
   */
  changeType(e) {
    E(this, q, e);
  }
};
ae = new WeakMap(), L = new WeakMap(), W = new WeakMap(), U = new WeakMap(), he = new WeakMap(), q = new WeakMap(), De = new WeakSet(), St = function() {
  window.addEventListener("popstate", (e) => this.popstate(e));
}, ke = new WeakSet(), Ct = function(e, t = "_self", s) {
  const i = g.htmlToEl(`<a href="${e}"></a>`), { pathname: n, origin: r } = i;
  return !e || window.location.origin !== r || s !== "popstate" && !e.includes("#") && window.location.pathname === n || o(this, ae).has(n) || t === "_blank" ? I.TRANSITION_TYPE.NON_SPA : e.includes("#") ? I.TRANSITION_TYPE.HASH : I.TRANSITION_TYPE.SPA;
}, Ae = new WeakSet(), Dt = async function(e) {
  const s = await (await window.fetch(e)).text();
  return new DOMParser().parseFromString(s, "text/html");
}, a(I, "TRANSITION_TYPE", {
  NON_SPA: 100,
  SPA: 101,
  HASH: 102
});
let Ke = I, B;
var _, T, P, Y, Z, H, k, le, A, Le, kt, ce, Je, Ue, At, de, et, ue, tt, _e, Lt, He, Ut;
const at = class at {
  constructor(e, t) {
    /**
     * イベントバインド
     */
    d(this, Le);
    d(this, ce);
    d(this, Ue);
    d(this, de);
    d(this, ue);
    /**
     * メッシュクリック時のアクション
     */
    d(this, _e);
    /**
     * リンククリック時のアクション
     */
    d(this, He);
    d(this, _, void 0);
    d(this, T, void 0);
    d(this, P, []);
    d(this, Y, !1);
    d(this, Z, !1);
    d(this, H, void 0);
    d(this, k, void 0);
    d(this, le, new Wt());
    d(this, A, !1);
    E(this, H, e), E(this, k, t), E(this, A, y.isTouchDevices()), w(this, Le, kt).call(this);
  }
  static async init(e, t) {
    return B || (B = new at(e, t)), B;
  }
  watchMarks(e) {
    e.forEach((t) => {
      t.dataAttrs[`${h.prefix.interactive}`] !== void 0 && this.watch(t);
    });
  }
  /**
   * {@link Ob} オブジェクトに含まれる [Mesh](https://threejs.org/docs/#api/en/objects/Mesh) のUI監視対象に追加します。  
   * 
   * ```ts
   * // メッシュをマウスの監視対象に追加
   * meshUI.watch(o);
   * meshUI.watch('.css-selector');
   * ```
   * 
   * **注意**  
   * `data-interactive`を付与したものは自動的にUIの監視対象になります。
   * ```html
   * <!-- 以下のHTMLに紐づくエフェクトは自動的に監視対象 -->
   * <div data-interactive data-webgl="some-effect"></div>
   * ```
   * 
   * @param obOrSelector {@link Ob} または セレクタ文字列
   * @returns 
   */
  watch(e) {
    let t;
    if (e instanceof HTMLElement || typeof e == "string" ? t = o(this, H).getObByEl(e) : e instanceof Ze && (t = e), !t) {
      console.warn("エフェクトが取得できないため、Raycastのターゲットとして登録できませんでした。 渡されたセレクター：", e);
      return;
    }
    const s = t.mesh;
    w(this, ue, tt).call(this, s).forEach((n) => {
      o(this, P).includes(n) || (this.resetUIData(n), o(this, P).push(n));
    });
  }
  /**
   * マウスのUIに関する情報を初期化します。
   * 
   * ```ts
   * // OBクラスに含まれるメッシュを監視対象から除外
   * meshUI.resetUIData(mesh);
   * ```
   */
  resetUIData(e) {
    if (e.userData.hoverTarget = 0, e.userData.hover = 0, e.userData.intersectUv = new We(0.5, 0.5), "material" in e && e.material instanceof ft) {
      const { uniforms: t } = e.material;
      t.uHover && (t.uHover.value = 0), t.uHover && (t.uMouse.value = new We(0.5, 0.5));
    }
  }
  /**
   * メッシュを監視対象から除外します。
   * 
   * ```ts
   * // OBクラスに含まれるメッシュを監視対象から除外
   * meshUI.unwatch(o);
   * // or 
   * meshUI.unwatch('.css-selector');
   * // or 
   * meshUI.unwatch(domElement);
   * ```
   */
  unwatch(e) {
    let t;
    if (e instanceof HTMLElement || typeof e == "string" ? t = o(this, H).getObByEl(e) : e instanceof Ze && (t = e), !t) {
      console.warn("エフェクトが取得できないため、Raycastのターゲットを削除できませんでした。 渡されたセレクター：", e);
      return;
    }
    const s = t.mesh;
    w(this, ue, tt).call(this, s).forEach((n) => {
      if (!o(this, P).includes(n))
        return;
      const r = o(this, P).indexOf(n);
      o(this, P).splice(r, 1);
    });
  }
  /**
   * メッシュクリックイベント発火を一時的に停止します。 
   *  
   * 例えば、`button`要素とメッシュが重なって表示されている場合に`button`のクリックイベントのみを実行し、メッシュのクリックイベントを発火させたくない場合には次のように記述します。
   * 
   * ```ts copy
   * buttonElement.addEventListener('click', () => {
   *  // ...
   *  // メッシュイベントの発火を停止
   *  meshUI.stopPropagation();
   * });
   * ```
   * 
   * 以下のフックに登録された処理が停止対象となります。
   * - `hook.on(hook.MOUSE_MESH_CLICK, ...)`
   */
  stopPropagation() {
    E(this, Y, !0);
  }
  /**
   * メッシュクリック時のデフォルト制御を一時的に停止します。  
   * 例えば、`button`要素とメッシュが重なって表示されている場合に`button`のクリックイベントのみを実行し、メッシュのクリックイベントを発火させたくない場合には次のように記述します。
   * 
   * ```ts copy
   * buttonElement.addEventListener('click', () => {
   *  // ...
   *  // メッシュのクリックイベントの発火を停止
   *  meshUI.stopPropagation();
   * });
   * ```
   * 
   * 以下の処理が停止対象となります。
   * - HTML内の`data-click-1`によって登録されたアクション、および画面遷移
   * - リンククリックによる画面遷移
   */
  preventDefault() {
    E(this, Z, !0);
  }
  /**
   * クリックのデフォルト制御
   * @internal
   * @param event 
   * @returns 
   */
  click(e) {
    if (o(this, A)) {
      const t = {
        current: {
          x: e.clientX,
          y: e.clientY
        }
      }, s = ve.prototype.getClipPos.call(t);
      w(this, ce, Je).call(this, s);
    }
    if (o(this, Y) || o(this, T) && c.trigger(c.MOUSE_MESH_CLICK, { mesh: o(this, _), mouse: o(this, k), ob: o(this, T), meshUI: this }), E(this, Y, !1), o(this, Z))
      return E(this, Z, !1);
    o(this, T) ? w(this, _e, Lt).call(this, e) : w(this, He, Ut).call(this, e);
  }
  /**
   * ホバー中のメッシュがあれば紐づく`Ob`オブジェクトを返却します。
   */
  getHoveringOb() {
    return o(this, T);
  }
  /**
   * ホバー中のメッシュがあれば対象のメッシュを返却します。
   * @returns [Obect3D](https://threejs.org/docs/#api/en/objects/Obect3D)
   */
  getHoveringMesh() {
    return o(this, _);
  }
  /**
   * 監視対象の初期化を行います。
   */
  reset() {
    E(this, _, void 0), o(this, T) && (o(this, T).hoveringMesh = void 0), E(this, T, void 0), E(this, P, []);
  }
};
_ = new WeakMap(), T = new WeakMap(), P = new WeakMap(), Y = new WeakMap(), Z = new WeakMap(), H = new WeakMap(), k = new WeakMap(), le = new WeakMap(), A = new WeakMap(), Le = new WeakSet(), kt = function() {
  g.getElement(h.$.globalContainer).addEventListener(h.event.click, (t) => this.click(t)), c.on(c.RESIZE_DELAY, () => {
    o(this, A) !== y.isTouchDevices() && window.location.reload();
  }), !o(this, A) && c.on(c.RENDER, () => {
    var s, i;
    if (h.meshUI.shouldObserve && !((i = (s = h.meshUI).shouldObserve) != null && i.call(s)))
      return;
    const t = o(this, k).getClipPos();
    w(this, ce, Je).call(this, t);
  });
}, ce = new WeakSet(), Je = function(e) {
  if (o(this, P).length === 0)
    return;
  o(this, le).setFromCamera(e, o(this, H).camera);
  const t = o(this, P).filter((n) => (!n.visible && n.userData.hoverTarget !== 0 && w(this, de, et).call(this, n), n.visible)), i = o(this, le).intersectObjects(t)[0];
  if (i) {
    const n = t.indexOf(i.object);
    if (n !== -1) {
      const [r] = t.splice(n, 1);
      t.unshift(r);
    }
  }
  for (let n = t.length - 1; n >= 0; n--) {
    const r = t[n], l = r.material;
    let f = !1;
    l.uniforms && "uMouse" in l.uniforms && "uHover" in l.uniforms && (f = !0), (i == null ? void 0 : i.object) === r ? (r.userData.intersectUv = i.uv, f && (l.uniforms.uMouse.value = i.uv), r.userData.hoverTarget !== 1 && w(this, Ue, At).call(this, r)) : r.userData.hoverTarget !== 0 && w(this, de, et).call(this, r), r.userData.hover = y.lerp(r.userData.hover, r.userData.hoverTarget, 0.1), f && (l.uniforms.uHover.value = r.userData.hover);
  }
}, Ue = new WeakSet(), At = function(e) {
  if (e.userData.hoverTarget = 1, E(this, _, e), E(this, T, o(this, H).getObByMesh(e)), o(this, T) && (o(this, T).hoveringMesh = e), o(this, A))
    return;
  c.trigger(c.MOUSE_MESH_ENTER, { mesh: e, mouse: o(this, k), ob: o(this, T), meshUI: this });
  const t = () => {
    c.trigger(c.MOUSE_MESH_HOVER, { mesh: e, mouse: o(this, k), ob: o(this, T), meshUI: this });
  };
  c.on(c.RENDER, t), c.on(c.MOUSE_MESH_LEAVE, () => {
    c.off(c.RENDER, t);
  }, { once: !0 });
}, de = new WeakSet(), et = function(e) {
  e.userData.hoverTarget = 0, o(this, A) || c.trigger(c.MOUSE_MESH_LEAVE, { mesh: e, mouse: o(this, k), ob: o(this, T), meshUI: this }), E(this, _, void 0), o(this, T) && (o(this, T).hoveringMesh = void 0), E(this, T, void 0);
}, ue = new WeakSet(), tt = function(e) {
  const t = [];
  function s(i) {
    i.children.length === 0 ? t.push(i) : i.children.forEach((n) => s(n));
  }
  return s(e), t;
}, _e = new WeakSet(), Lt = function(e) {
  return o(this, T).click({ meshUI: this, event: e, transition: J });
}, He = new WeakSet(), Ut = function(e) {
  const t = e.target.closest("a");
  if (!t)
    return;
  const { href: s, target: i } = t, n = g.getDS(t, h.prefix.transition);
  J.goTo({
    href: s,
    target: i,
    event: e,
    triggerType: "link",
    type: n
  });
};
let Qe = at, Q, me, R;
var X, $e, _t;
const ht = class ht {
  constructor({ canvas: e, clearColor: t = "#000000", clearAlpha: s }) {
    /**
     * 画面ロード時の初期化関数
     * @internal
     */
    d(this, $e);
    /**
     * Obオブジェクトの
     */
    a(this, "os", []);
    d(this, X, []);
    /**
     * レンダリング開始時点からのティック回数
     */
    a(this, "tick", 0);
    /**
     * {@link https://threejs.org/docs/#api/en/core/Clock THREE.Clock}オブジェクト
     */
    a(this, "clock");
    /**
     * {@link https://threejs.org/docs/#api/en/core/Clock.getDelta THREE.Clock#getDelta}の戻り値
     */
    a(this, "delta", 0);
    /**
     * {@link https://threejs.org/docs/#api/en/core/Scene THREE.Scene}オブジェクト
     */
    a(this, "scene", new qt());
    /**
     * {@link https://threejs.org/docs/#api/en/core/WebGLRenderer THREE.WebGLRenderer}オブジェクト
     */
    a(this, "renderer");
    /**
     * {@link https://threejs.org/docs/?q=Camera#api/en/cameras/Camera THREE.Camera}オブジェクト
     */
    a(this, "camera");
    a(this, "renderStart");
    this.renderer = new Yt({
      canvas: e,
      antialias: !0,
      precision: y.isTouchDevices() ? "highp" : "mediump"
    }), this.renderer.setSize(b.width, b.height, !1), this.renderer.setPixelRatio(b.devicePixelRatio), this.renderer.setClearColor(t, s), this.camera = this.setupPerspectiveCamera(b), this.clock = new Zt(), this.renderStart = () => {
      this.render(), requestAnimationFrame(this.renderStart);
    };
  }
  static async init(e) {
    var t;
    return R || (R = new ht(e), await w(t = R, $e, _t).call(t)), R;
  }
  async afterInit() {
    const e = this.os.map(async (t) => {
      await t.afterInit();
    });
    await Promise.all(e);
  }
  cacheCurrentOs() {
    o(this, X).push(...this.os);
  }
  // 各エフェクト（Obオブジェクト）の初期化関数
  async initObs(e = document) {
    const s = [...g.qsAll(`[data-${h.prefix.ob}]`, e)].map((i) => this.initOb(i));
    return await Promise.all(s);
  }
  async initOb(e) {
    const t = o(this, X).findIndex((i) => i.$.el === e);
    if (t !== -1) {
      let [i] = o(this, X).splice(t, 1);
      return i.isCache = !0, Promise.resolve(i);
    }
    const s = g.getDS(e, h.prefix.ob);
    if (s === void 0)
      throw new Error(`data-${h.prefix.ob}にエフェクトを設定してください。`);
    try {
      return await (await Et.get(s)).init({ type: s, el: e });
    } catch (i) {
      return h.debug && console.warn(`[data-${h.prefix.ob}="${s}"]の作成をスキップしました。`), h.debug && console.warn(i), {};
    }
  }
  /**
   * HTML文字列、またはDOM要素からObオブジェクトを作成します。  
   * これまではHTML内にエフェクトの元となるHTMLを必ず記述する必要がありましたが、JSから作成したい場合にこのメソッドを使用します。
   * 
   * ```js
   * const templateOb = await world.createOb(`
   *  <img data-webgl="template" data-interactive data-click-1="/detail.html" />
   * `)
   * ```
   * 
   * @param elOrHtmlStr HTML文字列、またはDOM要素
   * @param options 以下のオプションを設定可能です。
   * @param options.updateStyle 
   *        `true` HTML要素に`{ visibility: 'hidden'; position: 'absolute'; top: 0; }`が付与された状態でDOMツリーに挿入されます。<br/>
   *        `false` スタイルは更新せず、DOMツリーに挿入します。
   * @param options.parent createObによって作成されたDOMを挿入する親のDOMを指定します。指定しない場合は `config.$.globalContainer` の子要素としてDOMが挿入されます。
   */
  async createOb(e, t = {}) {
    const s = { updateStyle: !0, parent: h.$.globalContainer, ...t };
    let i;
    if (typeof e == "string")
      i = g.htmlToEl(e);
    else if (e instanceof HTMLElement)
      i = e;
    else
      throw new Error("HTMLElement もしくは HTML文字列を渡してください。");
    s.updateStyle && (i.style.visibility = "hidden", i.style.position = "absolute", i.style.top = "0");
    let n = g.getElement(s.parent);
    n.contains(i) || n.append(i);
    const r = await this.initOb(i);
    return r.mesh && (R.addOb(r), await r.resize(0), await r.afterInit(), r.mesh.visible = !0, B.watchMarks([r]), h.debug && z.addObDebug(r)), r;
  }
  /**
   * Obオブジェクトをシーン内に追加します。
   * 
   * **注意**  
   * HTML内の`data-webgl`で指定したObオブジェクトや{@link World#createOb}で作成したObオブジェクトは自動的にシーンに追加されます。
   * @param o Obオブジェクト 
   */
  addOb(e) {
    var t;
    e.mesh && ((t = this.scene) == null || t.add(e.mesh), this.os.push(e));
  }
  /**
   * [廃止]
   * @deprecated {@link World#removeOb removeOb} を代わりに使用してください。
   */
  removeObj(e, t = !0) {
    console.warn("[deprecated] world.removeObj 廃止予定です。world.removeOb を代わりに使用してください。"), this.removeOb(e, t);
  }
  /**
   * Obオブジェクトをシーン内から削除します。
   * @param o Obオブジェクト
   * @param dispose `true` Obオブジェクトに紐づく`Mesh`を完全に削除します。<br/>
   *                `false` シーンからのみ除外します。
   */
  removeOb(e, t = !0) {
    if (!e)
      return h.debug || console.error("o is undefined");
    if (e.mesh === void 0)
      throw new Error("meshプロパティが存在しません。");
    this.scene.remove(e.mesh);
    const s = this.os.indexOf(e);
    this.os.splice(s, 1), t && this.disposeMesh(e.mesh);
  }
  /**
   * 引数で渡されたObオブジェクト配列に含まれるメッシュの[visible](https://threejs.org/docs/?q=Mesh#api/en/core/Object3D)プロパティを全て`true`（表示）の状態にします。　
   * @param os Obオブジェクト配列
   */
  displayMeshes(e) {
    e != null && e.length && e.length > 0 && e.forEach((t) => t.mesh.visible = !0);
  }
  /**
   * 引数で渡されたObオブジェクト配列に含まれるメッシュの[visible](https://threejs.org/docs/?q=Mesh#api/en/core/Object3D)プロパティを全て`false`（非表示）の状態にします。　
   * @param os Obオブジェクト配列
   */
  hideMeshes(e) {
    e != null && e.length && e.length > 0 && e.forEach((t) => t.mesh.visible = !1);
  }
  /**
   * メッシュに含まれる全ての`Material`と`Geometry`を再起的に破棄（`dispose`）します。
   * @param mesh メッシュ
   */
  disposeMesh(e) {
    var t, s, i, n;
    e.children.length && e.children.forEach((r) => this.disposeMesh(r)), (s = (t = e.material) == null ? void 0 : t.dispose) == null || s.call(t), (n = (i = e.geometry) == null ? void 0 : i.dispose) == null || n.call(i);
  }
  /**
   * セレクタ文字列、またはDOM要素からObオブジェクトを取得します。
   * @param obOrSelector セレクタ文字列、DOM要素
   * @returns DOMに紐づくObオブジェクト
   * 
   * ```ts copy
   * const panelO = world.getObByEl('.panel-selector');
   * panelO.mesh.visible = false; // メッシュを非表示
   * ```
   */
  getObByEl(e) {
    if (e instanceof Ze)
      return e;
    const t = g.getElement(e);
    return this.os.find((s) => s.$.el === t);
  }
  /**
   * セレクタ文字列に一致する全てのDOM要素に紐づくObオブジェクトを含む配列を取得します。
   * @param selector セレクタ文字列
   * @returns DOMに紐づくObオブジェクト配列
   * 
   * ```ts copy
   * const panelOs = world.getObByElAll('.panel-selector');
   * panelOs[0].mesh.visible = false; // 一つ目のメッシュを非表示
   * panelOs[1].mesh.position.x += 500; // 二つ目のメッシュの位置を右に`500`移動
   * ```
   */
  getObByElAll(e) {
    return g.qsAll(e).map((s) => this.getObByEl(s)).filter((s) => s);
  }
  /**
   * [廃止]
   * @deprecated {@link World#getObByEl getObByEl} を代わりに使用してください。
   */
  getObjByEl(e) {
    return console.warn("[deprecated] world.getObByEl 廃止予定です。world.getObByEl を代わりに使用してください。"), this.getObByEl(e);
  }
  /**
   * [PerspectiveCamera](https://threejs.org/docs/?q=PerspectiveCamera#api/en/cameras/PerspectiveCamera)の作成を行います。
   * @internal
   * @param viewport 
   */
  setupPerspectiveCamera(e) {
    const { fov: t, aspect: s, near: i, far: n, cameraZ: r } = e, l = new ct(t, s, i, n);
    return l.position.z = r, l;
  }
  async adjustWorldPosition(e, t = 1) {
    var i;
    (i = this.renderer) == null || i.setSize(e.width, e.height, !1);
    const s = await this.os.map((n) => n.resize(t));
    await Promise.all(s);
  }
  /**
   * 画面幅が変更した際のカメラの`fov`と`aspect`を更新します。
   * @param viewport 
   */
  updateCamera(e) {
    const { fov: t, aspect: s } = e, { camera: i } = this;
    i instanceof ct && (i.aspect = s, i.fov = t, i.updateProjectionMatrix());
  }
  /**
   * canvasへのレンダリングの処理を実行します。  
   * このメソッドは requestAnimationFrame でループ実行されます。
   * 
   * また、render メソッド内では以下の処理により画面描写を行っています。
   * 
   * ```js filename="画面描写処理"
   * this.renderer.render(this.scene, this.camera);
   * ```
   * 
   * その為、もしEffectComposer等でパスを適用したい場合は config.world.autoRender を false に設定し、以下のようにして composer.render を実行してください。
   * 
   * ```js
   * // デフォルトの renderer.render の実行を無効化
   * config.world.autoRender = false;
   * 
   * composer = new EffectComposer(world.renderer);
   * const renderPass = new RenderPass(world.scene, world.camera);
   * composer.addPass(renderPass);
   * 
   * // hook.RENDERに登録（requestAnimationFrame のループ内で実行されるようになる）
   * hook.on(
   *   hook.RENDER,
   *   () => {
   *     // composer.render を requestAnimationFrame のタイミングで実行
   *     composer.render();
   *   },
   *   // priority: -1000 で実行の優先度を下げる
   *   { priority: -1000 }
   * );
   * ```
   * 
   * また、[Travelサイト](/portfolio/travel)では getComposer.js という composer を取得する関数をご用意しています。こちらを使えば、裏側の処理を気にせず、composer を使用することができます。
   * 
   * **getComposer.js**は以下のフォルダに格納されています。
   * travel/src/scripts/parts/helper/getComposer.js
   */
  render() {
    this.tick++, this.delta = this.clock.getDelta();
    for (let e = this.os.length - 1; e >= 0; e--)
      this.os[e].render(this.tick, this.delta);
    c.trigger(c.RENDER, R), h.world.autoRender && this.renderer.render(this.scene, this.camera);
  }
  /**
   * メッシュに紐づくObクラスを取得します。
   * @param targetMesh 
   * @returns `targetMesh`を含むObクラス
   */
  getObByMesh(e) {
    return this.os.find(({ mesh: t }) => this.containsMesh(t, e));
  }
  containsMesh(e, t) {
    return e === t ? !0 : e.children.some((s) => this.containsMesh(s, t));
  }
  /**
   * lil-guiのOrbitControlチェックボックスを追加します。
   * @internal
   * @param gui lilGUIオブジェクト
   * @param defaultVal `true` チェックボックスにデフォルトチェック。`false` チェックなし。
   */
  addOrbitControlGUI(e, t = !1) {
    const s = { value: t };
    e.add(s, "value").name("OrbitControl").onChange(() => {
      var i;
      s.value ? (Q = new Xt(1e3), (i = this.scene) == null || i.add(Q), this.attachOrbitControl()) : (Q == null || Q.dispose(), this.detachOrbitControl());
    });
  }
  /**
   * [OrbitControls](https://threejs.org/docs/?q=OrbitControl#examples/en/controls/OrbitControls)をシーンに追加します。
   * @internal
   */
  attachOrbitControl() {
    import("three/examples/jsm/controls/OrbitControls").then(({ OrbitControls: e }) => {
      me = new e(this.camera, this.renderer.domElement), this.renderer.domElement.style.zIndex = "1";
    });
  }
  /**
   * [OrbitControls](https://threejs.org/docs/?q=OrbitControl#examples/en/controls/OrbitControls)をシーンから削除します。
   * @internal
   */
  detachOrbitControl() {
    me == null || me.dispose(), this.renderer.domElement.style.zIndex = "-1";
  }
  /**
   * イベントのバインド
   * @internal
   */
  bindEvents() {
    h.viewport.autoresize && (c.on(c.RESIZE_DELAY, (e) => {
      this.adjustWorldPosition(e, h.viewport.resizeDuration);
    }), c.on(c.RESIZE, () => {
      this.updateCamera(b);
    }));
  }
  /**
   * [廃止]
   * @deprecated {@link MeshUI#watch MeshUI#watch} を代わりに使用してください。
   */
  addRaycastingTarget(e) {
    console.warn("[deprecated]world.addRaycastingTarget廃止予定です。meshUI.watchを代わりに使用してください。"), B.watch(e);
  }
};
X = new WeakMap(), $e = new WeakSet(), _t = async function() {
  (await this.initObs()).forEach((t) => this.addOb(t)), await this.adjustWorldPosition(b, 1), this.displayMeshes(this.os), this.bindEvents();
};
let st = ht, ee;
function os(u = {}) {
  return ee = it.init(u), { start: is, hook: c };
}
async function is(u) {
  return te.addProgressAction(u), await ee.init();
}
var Ne, Ht;
const lt = class lt {
  constructor(e = {}) {
    d(this, Ne);
    a(this, "$");
    /**
     * {@link Hook}オブジェクトへのアクセスを提供します。
     */
    a(this, "hook", c);
    /**
     * {@link Config}オブジェクトへのアクセスを提供します。
     */
    a(this, "config");
    /**
     * {@link utils}オブジェクトへのアクセスを提供します。
     */
    a(this, "utils");
    /**
     * {@link INode}オブジェクトへのアクセスを提供します。
     */
    a(this, "INode", g);
    /**
     * 自オブジェクト（Neglオブジェクト）を返します。以下のような書き方が可能です。
     *
     * ```js
     * const { negl } = negl;
     * ```
     */
    a(this, "negl");
    /**
     * {@link World}オブジェクトへのアクセスを提供します。 {@link start}関数の実行後にアクセス可能です。
     */
    a(this, "world");
    /**
     * {@link Viewport}オブジェクトへのアクセスを提供します。 {@link start}関数の実行後にアクセス可能です。
     */
    a(this, "viewport");
    /**
     * {@link Scroller}オブジェクトへのアクセスを提供します。 {@link start}関数の実行後にアクセス可能です。
     */
    a(this, "scroller");
    /**
     * {@link Mouse}オブジェクトへのアクセスを提供します。 {@link start}関数の実行後にアクセス可能です。
     */
    a(this, "mouse");
    /**
     * {@link Transition}オブジェクトへのアクセスを提供します。 {@link start}関数の実行後にアクセス可能です。
     */
    a(this, "transition");
    /**
     * {@link Loader}オブジェクトへのアクセスを提供します。 {@link start}関数の実行後にアクセス可能です。
     */
    a(this, "loader");
    /**
     * {@link Gui}オブジェクトへのアクセスを提供します。 {@link start}関数の実行後にアクセス可能です。
     */
    a(this, "gui");
    /**
     * {@link MeshUI}オブジェクトへのアクセスを提供します。 {@link start}関数の実行後にアクセス可能です。
     */
    a(this, "meshUI");
    const { resolver: t, $: s } = this.config = Kt(e);
    Et.set(t.ob), Ee.set(t.page);
    const i = g.getElement(s.pageContainer);
    let n = g.getElement(s.canvas);
    const r = g.getElement(s.globalContainer);
    this.$ = {
      canvas: n,
      globalContainer: r,
      pageContainer: i
    }, this.utils = y, this.negl = this;
  }
  /**
   * 初期化処理
   * @internal
   * @returns
   */
  static init(e) {
    return ee || (ee = new lt(e)), ee;
  }
  /**
   * 初期化処理
   * @internal
   * @returns
   */
  async init() {
    var e;
    try {
      const {
        viewport: { cameraZ: t, near: s, far: i },
        world: { clearColor: n, clearAlpha: r },
        transition: { spaMode: l, cache: f, defaultType: p },
        addon: x,
        override: m
      } = this.config, { canvas: M, pageContainer: $ } = this.$;
      Object.assign(mt, x), this.scroller = ((m == null ? void 0 : m.scroller) ?? ss).init(), this.transition = Ke.init({ spaMode: l, cache: f, defaultType: p }), this.viewport = qe.init({
        canvas: M,
        cameraZ: t,
        near: s,
        far: i
      }), this.gui = await Ye.init(), await te.loadAllAssets();
      const C = this.world = await st.init({
        canvas: this.$.canvas,
        clearColor: n,
        clearAlpha: r
      }), j = this.mouse = ve.init();
      (this.meshUI = await Qe.init(C, j)).watchMarks(C.os), this.gui && this.gui.addRecommendGUI(C);
      const N = g.getDS(
        this.$.pageContainer,
        h.prefix.page
      );
      if (this.loader = te, w(this, Ne, Ht).call(this), await C.afterInit(), this.hook.trigger(this.hook.BEFORE_PAGE_INIT, this), N) {
        const v = await Ee.get(N);
        await ((e = v == null ? void 0 : v.default) == null ? void 0 : e.call(v));
      }
      return this;
    } catch (t) {
      console.error(t);
      debugger;
    }
  }
  /**
   * WebGLのレンダリングを開始します。three.js のシーンのレンダリングを開始したいタイミングで実行してください。
   */
  renderStart() {
    if (!this.world)
      throw new Error("Negl.initを先に実行してください。");
    this.hook.trigger(this.hook.T_INIT, {}), this.world.renderStart();
  }
};
Ne = new WeakSet(), Ht = function() {
  c.on(c.SCROLL, () => {
    if (this.world)
      for (let e = this.world.os.length - 1; e >= 0; e--)
        this.world.os[e].scroll();
  });
};
let it = lt;
export {
  Ye as Gui,
  Jt as Hook,
  g as INode,
  ts as Loader,
  Qe as MeshUI,
  wt as ModuleResolver,
  ve as Mouse,
  it as Negl,
  Ze as Ob,
  Et as ObResolver,
  Ee as PageResolver,
  ss as Scroller,
  Ke as Transition,
  Qt as Utils,
  qe as Viewport,
  st as World,
  mt as addon,
  h as config,
  z as gui,
  c as hook,
  te as loader,
  Kt as mergeConfig,
  B as meshUI,
  we as mouse,
  ee as negl,
  F as scroller,
  os as setup,
  is as start,
  J as transition,
  y as utils,
  b as viewport,
  R as world
};
