import { defineConfig } from "vite";
import { resolve } from "path";
import { splitVendorChunkPlugin } from "vite";
import glslify from "rollup-plugin-glslify";
import dynamicImport from "vite-plugin-dynamic-import";
const root = "src";

export default defineConfig({
  root,
  base: "/",
  publicDir: "../public",
  plugins: [
    dynamicImport(),
    splitVendorChunkPlugin(),
    glslify({
      compress(code) {
        // Based on https://github.com/vwochnik/rollup-plugin-glsl
        // Modified to remove multiline comments. See #16
        let needNewline = false;
        return code
          .replace(
            /\\(?:\r\n|\n\r|\n|\r)|\/\*.*?\*\/|\/\/(?:\\(?:\r\n|\n\r|\n|\r)|[^\n\r])*/gs,
            ""
          )
          .split(/\n+/)
          .reduce((result, line) => {
            line = line.trim().replace(/\s{2,}|\t/, " "); // lgtm[js/incomplete-sanitization]
            if (line.charAt(0) === "#" || /else/.test(line)) {
              if (needNewline) {
                result.push("\n");
              }
              result.push(line, "\n");
              needNewline = false;
            } else {
              result.push(
                line.replace(
                  /\s*({|}|=|\*|,|\+|\/|>|<|&|\||\[|\]|\(|\)|-|!|;)\s*/g,
                  "$1"
                )
              );
              needNewline = true;
            }
            return result;
          }, [])
          .join(process.env.NODE_ENV === "development" ? "\n" : "")
          .replace(/\n+/g, "\n");
      },
    }),
  ],
  resolve: {
    alias: {
      "#": resolve(__dirname, root, `scripts`),
      three: resolve(__dirname, "node_modules", "three"),
    },
  },
  build: {
    outDir: "../dist",
    manifest: true,
    rollupOptions: {
      input: {
        // htmlを追加する場合にはこちらに追記
        // Add html here if needed
        index: resolve(root, "index.html"),
        menu: resolve(root, "menu.html"),
        hokkaido: resolve(root, "hokkaido.html"),
        kyoto: resolve(root, "kyoto.html"),
        nara: resolve(root, "nara.html"),
        okinawa: resolve(root, "okinawa.html"),
        osaka: resolve(root, "osaka.html"),
        shiga: resolve(root, "shiga.html"),
        tokyo: resolve(root, "tokyo.html"),
        tottori: resolve(root, "tottori.html"),
        wakayama: resolve(root, "wakayama.html"),
      },
    },
  },
  server: {
    host: true,
  },
});
