varying vec2 vUv;
uniform float uLevel;
uniform sampler2D tDiffuse;

vec2 distort(vec2 p, float barrelPower) {
  p -= 0.5;
  float theta = atan(p.y, p.x);
  float radius = length(p);
  radius = pow(radius, barrelPower);
  p.x = radius * cos(theta);
  p.y = radius * sin(theta);
  p += 0.5;
  return p;
}

void main() {
  vec2 uv = vUv;
  float power = uLevel;

  vec2 distortUv = distort(uv, power);
  vec2 fractUv = fract(distortUv);
  vec4 t1 = texture2D(tDiffuse, fractUv);
  gl_FragColor = t1;
}