import { getComposer } from "#/parts/helper/getComposer";
import { ShaderPass } from "three/examples/jsm/postprocessing/ShaderPass";

let instance;

async function initBarrelPass({ world }) {
  /**
   * 2回以上Passをシーンに追加しないため、すでに instance が設定されている場合はそれを返却
   * To avoid adding the Pass to the scene more than twice, return the existing instance if one is already set.
   */
  if (instance) return instance;
  const o = await world.createOb(`<div
  data-webgl="barrel-distortion"
  style="width: 100vw; height: 100vh;"
  ></div>`);

  const { material, uniforms } = o;
  world.removeOb(o, false);
  uniforms.tDiffuse = { value: null };

  const pass = new ShaderPass(material);
  pass.uniforms.uLevel = o.uniforms.uLevel;
  const composer = getComposer();
  composer.addPass(pass);

  function removePass(dispose = true) {
    composer.removePass(pass);
    if (dispose) {
      o.geometry.dispose();
      o.material.dispose();
    }
  }

  function addPass() {
    composer.addPass(pass);
  }

  instance = {
    addPass,
    removePass,
    setProgress,
  };
  return instance;
}

export default initBarrelPass;
