import { EffectComposer } from "three/examples/jsm/postprocessing/EffectComposer";
import { RenderPass } from "three/examples/jsm/postprocessing/RenderPass";
import { world, hook, config } from "negl";

/**
 * Returns an {@link https://threejs.org/docs/?q=EffectComposer#examples/en/postprocessing/EffectComposer EffectComposer} object.
 * EffectComposerオブジェクトを返却します。
 */
let composer = null;
export function getComposer() {
  // If the composer already exists, do not execute the following process
  // 既にcomposerが存在する場合は以降の処理を実行しない
  if (composer) return composer;

  // Disable the execution of the default renderer.render
  // デフォルトの renderer.render の実行を無効化
  config.world.autoRender = false;

  composer = new EffectComposer(world.renderer);
  const renderPass = new RenderPass(world.scene, world.camera);
  composer.addPass(renderPass);

  // Register to hook.RENDER (to be executed within the requestAnimationFrame loop)
  // hook.RENDERに登録（requestAnimationFrame のループ内で実行されるようになる）
  hook.on(
    hook.RENDER,
    () => {
      // Execute composer.render at the timing of requestAnimationFrame
      // composer.render を requestAnimationFrame のタイミングで実行
      composer.render();
    },
    // Set the execution priority lower with priority: -1000
    // priority: -1000 で実行の優先度を下げる
    { priority: -1000 }
  );
  return composer;
}
