﻿// 参考
// https://www.shadertoy.com/view/WdVSWd
/*
This is free and unencumbered software released into the public domain.

Anyone is free to copy, modify, publish, use, compile, sell, or distribute this software, either in source code form or as a compiled binary, for any purpose, commercial or non-commercial, and by any means.

In jurisdictions that recognize copyright laws, the author or authors of this software dedicate any and all copyright interest in the software to the public domain.
We make this dedication for the benefit of the public at large and to the detriment of our heirs and successors.
We intend this dedication to be an overt act of relinquishment in perpetuity of all present and future rights to this software under copyright law.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

For more information, please refer to <http://unlicense.org/>
*/

#pragma glslify: coverUv = require(../shader-util/coverUv)
#pragma glslify: grayscale = require(../shader-util/grayscale)

uniform vec4 uResolution;
uniform float uHover;
uniform float uTick;
uniform vec2 uMouse;
uniform float uAlpha;
uniform sampler2D tex1;
varying vec2 vUv;
uniform sampler2D tDiffuse;



const float GoldenAngle = 2.39996323;

// more is better quality
const float Iterations = 400.0;

const mat2 Rotation = mat2(
    cos(GoldenAngle),
    sin(GoldenAngle),
   -sin(GoldenAngle),
    cos(GoldenAngle)
);

const float ContrastAmount = 150.0;
const vec3 ContrastFactor = vec3(9.0);
const float Smooth = 2.0;


///////////
/*
	calculates circle of confusion diameter for each fixel from physical parameters and depth map

	this function is unused

	see http://ivizlab.sfu.ca/papers/cgf2012.pdf, page 10
*/
float blurRadius(
    float A, // aperture
    float f, // focal length
    float S1, // focal distance
    float far, // far clipping plane
    float maxCoc, // mac coc diameter
    
	vec2 uv,
	sampler2D depthMap)
{
    vec4 currentPixel = texture(depthMap, uv);
    
    float S2 = currentPixel.r * far;
    
    //https://en.wikipedia.org/wiki/Circle_of_confusion
    float coc = A * ( abs(S2 - S1) / S2 ) * ( f / (S1 - f) );
    
    float sensorHeight = 0.024; // 24mm
    
    float percentOfSensor = coc / sensorHeight;
    
    // blur factor
    return clamp(percentOfSensor, 0.0, maxCoc);
}
///////////

vec3 bokeh(sampler2D tex, vec2 uv, float radius) {
	vec3 num, // numerator                       acc = areas concentric circles? ( ͡° ͜ʖ ͡°)
		 weight;
    
    float rec = 1.0; // reciprocal 
    
    vec2 horizontalAngle = vec2(0.0, radius * 0.01 / sqrt(Iterations));
    
    vec2 aspect = vec2(uResolution.y/uResolution.x, 1.0);
    
	for (float i; i < Iterations; i++) {
        rec += 1.0 / rec;
        
	    horizontalAngle = horizontalAngle * Rotation;
        
        vec2 offset = (rec - 1.0) * horizontalAngle;
        
        vec2 sampleUV = uv + aspect * offset;
        
        vec3 col = texture(tex, sampleUV).rgb;
        
        // increase contrast and smooth
		vec3 bokeh = Smooth + pow(col, ContrastFactor) * ContrastAmount;
        
		num += col * bokeh;
		weight += bokeh;
	}
	return num / weight;
}


void main() {
  vec2 uv = coverUv(vUv, uResolution);
  
  // vec2 uv = fragCoord.xy / iResolution.xy;
  float rad = ((1.0 - uHover) * 150./uResolution.x) * 14.0;
	gl_FragColor = vec4(bokeh(tex1, uv, rad), uAlpha);
	// gl_FragColor = vec4(col, 1.0); 
}
