varying vec2 vUv;
uniform sampler2D tex1;
uniform vec4 uResolution;
uniform float uProgress;
uniform float uAlpha;
#pragma glslify: coverUv = require(../shader-util/coverUv);

float circle(in float dist, in float radius, in float blur, in float boundary) {
    return smoothstep(radius + (radius * blur), radius - (radius * blur + boundary), dist);
}

void main() {
    float boundary = 0.01;
    // a値によるブラー  Blur by alpha value
    float blur = 0.0;

    blur *= uProgress;
    float radius = length(uResolution.xy) * (1. + blur) * uProgress;
    vec2 uv = coverUv(vUv, uResolution);
    vec4 color = texture2D(tex1, uv);
    float dist = length(2.0 * gl_FragCoord.xy - uResolution.xy);

    float clip = circle(dist, radius, blur, boundary);
    vec4 fragColor = vec4(color.rgb, clip * (1. - uAlpha));
    gl_FragColor = (fragColor.a < boundary) ? vec4(0.9725, 0.9451, 0.8824, (1. - uAlpha)) : fragColor;

}