import { Ob } from "negl";
import vertexShader from "./vertex.glsl";
import fragmentShader from "./fragment.glsl";
import gsap from "gsap";

export default class extends Ob {
  setupVertex() {
    return vertexShader;
  }
  setupFragment() {
    return fragmentShader;
  }
  afterInit() {
    this.mesh.position.z = 1;
  }
  setUpUnifroms() {
    uniforms = super.setUpUnifroms();

    uniforms.uProgress = { value: 0.15 };

    return uniforms;
  }
  debug(folder) {
    folder
      .add(this.uniforms.uProgress, "value", 0, 1, 0.00001)
      .name("progess")
      .listen();
    folder
      .add(this.uniforms.uAlpha, "value", 0, 1, 0.01)
      .name("alpha")
      .listen();

    const lilData = { next: !!this.uniforms.uProgress.value };

    folder.add(lilData, "next").onChange(() => {
      gsap.to(this.uniforms.uProgress, {
        value: +lilData.next,
        duration: 2,
        ease: "power2.inOut",
      });
    });
  }
}
