// author: existical
// https://www.shadertoy.com/view/Xltfzj
varying vec2 vUv;
uniform sampler2D tex1;
uniform vec4 uResolution;
void main() {
    float Pi = 6.28318530718; // Pi*2

    // GAUSSIAN BLUR SETTINGS {{{
    float Directions = 16.0; // BLUR DIRECTIONS (Default 16.0 - More is better but slower)
    float Quality = 3.0; // BLUR QUALITY (Default 4.0 - More is better but slower)
    float Size = 8.0; // BLUR SIZE (Radius)
    // GAUSSIAN BLUR SETTINGS }}}

    vec2 Radius = Size / uResolution.xy;

    // Normalized pixel coordinates (from 0 to 1)
    vec2 uv = vUv;
    // Pixel colour
    vec4 color = texture2D(tex1, uv);

    // Blur calculations
    for(float d = 0.0; d < Pi; d += Pi / Directions) {
        for(float i = 1.0 / Quality; i <= 1.0; i += 1.0 / Quality) {
            color += texture(tex1, uv + vec2(cos(d), sin(d)) * Radius * i);
        }
    }
    // Output to screen
    color /= Quality * Directions - 15.0;
    gl_FragColor = color;
}