precision mediump float;

#pragma glslify: noise2 = require(glsl-noise/simplex/2d);
#pragma glslify: noise3 = require(glsl-noise/simplex/3d);
#pragma glslify: coverUv = require(../shader-util/coverUv);
varying vec2 vUv;
uniform vec4 uResolution;
uniform sampler2D tex1;
uniform vec3 uBorderColor;

void main() {
  vec2 uv = vUv;
  float aspect = uResolution.x / uResolution.y;
  uv.x -= 0.5;
  uv.x *= aspect;
  uv.x += 0.5;

  const float radius = 0.99;
  const float borderThickness = 0.01;
  uv = uv - vec2(0.5);
  float d = sqrt(dot(uv, uv)) * 2.0;
  float t1 = 1.0 - smoothstep(radius - borderThickness, radius, d);
  float t2 = 1.0 - smoothstep(radius, radius + borderThickness, d);

  vec4 color = texture(tex1, vUv);

  color = vec4(mix(uBorderColor.rgb, color.rgb, t1), t2);

  gl_FragColor = color; // ボーダーの色を設定
}