import vertexShader from "./vertex.glsl";
import fragmentShader from "./fragment.glsl";
import { Ob } from "negl";
import { Color } from "three";

export default class extends Ob {
  beforeCreateMesh() {
    this.borderColor = "#ffffff";
  }
  setupUniforms() {
    const uniforms = super.setupUniforms();
    uniforms.uBorderColor = { value: new Color(this.borderColor) };
    return uniforms;
  }
  setupVertex() {
    return vertexShader;
  }
  setupFragment() {
    return fragmentShader;
  }
  debug(folder) {
    folder.addColor(this, "borderColor").onChange(() => {
      this.uniforms.uBorderColor.value.set(this.borderColor);
    });
  }
  resize() {
    // resizeを無効化
  }
}
