varying vec2 vUv;
uniform vec2 uMouse;
uniform vec4 uResolution;
uniform float uHover;
uniform float uProgress;
uniform vec3 uParams;
uniform float uAlpha;
uniform float uTick;
uniform sampler2D tex1;
uniform sampler2D tex2;

// 関数をインポート
// Import functions
#pragma glslify: coverUv = require(../shader-util/coverUv);
#pragma glslify: snoise = require(glsl-noise/simplex/3d.glsl);

void main() {
    // テクスチャ座標（uv座標）の取得
    // Get texture coordinates (uv coordinates)
    vec2 uv = coverUv(vUv, uResolution);

    // ノイズの取得 Get noise
    float n = snoise(vec3(uv.x * uParams.x, uv.y * uParams.y, uTick * 0.01));

    // data-tex-1の画像の色情報を取得
    // Get color information from the image in data-tex-1
    vec4 t1 = texture2D(tex1, uv);

    // data-tex-2の画像の色情報を取得
    // Get color information from the image in data-tex-2
    vec4 t2 = texture2D(tex2, uv);

    // マウスの座標をメッシュのアスペクトに合わせる
    // Adjust the mouse coordinates to match the mesh's aspect
    vec2 mouse = coverUv(uMouse, uResolution);
    
    // テクスチャ座標（uv座標）にノイズを足し合わせる
    // Add noise to the texture coordinates (uv coordinates)
    vec2 distortUv = uv + n * (.5 - abs(uv.x - 0.5)) * uParams.z;

    // マウスのX座標に合わせて分割
    // Split based on the mouse's X coordinate
    float split = step(mouse.x, distortUv.x);

    // マウスのY座標に合わせて分割したい場合はこちらを利用
    // Use this to split based on the mouse's Y coordinate
    // float split = step(uMouse.y, distortUv.y);

    // data-tex-1の画像とdata-tex-2の画像をsplitXの値によって混ぜ合わせる
    // Mix the images from data-tex-1 and data-tex-2 based on the value of splitX
    vec4 color = mix(t1, t2, split);

    // 画面に表示する色を設定
    // Set the color to display on the screen
    gl_FragColor = color;

    // 4. ローディングアニメーション時の透明度の変更
    // 4. Change the opacity during loading animation
    gl_FragColor.a *= uAlpha;
}