﻿
#pragma glslify: coverUv = require(../shader-util/coverUv)
#pragma glslify: grayscale = require(../shader-util/grayscale)

uniform vec4 uResolution;
uniform float uHover;
uniform float uTick;
uniform sampler2D tex1;
uniform sampler2D tex2;
varying vec2 vUv;

void main() {
	vec2 uv = coverUv(vUv, uResolution);
	vec4 color = texture2D(tex1, uv);

  // vec2 uv = gl_FragCoord.xy / uResolution.xy;
	float repeatValue = mod(uv.y * 0.1 + uTick * 0.00125, 1.0);
	vec3 raintex = texture(tex2, vec2(uv.x * 1.0, repeatValue)).rgb / 16.0;
	vec2 where = (uv.xy + 0.03 - raintex.xy);
	vec4 texchur1 = texture(tex1, vec2(where.x, where.y));

	gl_FragColor = mix(texchur1, color, uHover);
	// gl_FragColor = mix(color, texchur1 ,uHover);
}
