import { Vector2, MirroredRepeatWrapping } from "three";
import vertexShader from "./vertex.glsl";
import fragmentShader from "./fragment.glsl";
import { config } from "negl";
import { SingleMeshSlider } from "#/parts/helper/slider/SingleMeshSlider";
export default class extends SingleMeshSlider {
  setupTexes(uniforms) {
    this.texes.forEach((tex, key) => {
      const newTex = tex.clone();
      newTex.wrapT = MirroredRepeatWrapping;
      newTex.wrapS = MirroredRepeatWrapping;

      this.texes.set(key, newTex);
    });
    super.setupTexes(uniforms);
    const dispKey = `${config.prefix.tex}Disp`;
    uniforms.texDisp = { value: this.texes.get(dispKey) };
    this.texes.delete(dispKey);
    return uniforms;
  }
  setupUniforms() {
    const uniforms = super.setupUniforms();
    uniforms.uNoiseScale = { value: new Vector2(2, 2) };
    return uniforms;
  }
  setupVertex() {
    console.log(this.uniforms);
    return vertexShader;
  }
  setupFragment() {
    return fragmentShader;
  }
  debug(folder) {
    super.debug(folder);

    folder.add(this.uniforms.uNoiseScale.value, "x", 0, 10, 0.1);
    folder.add(this.uniforms.uNoiseScale.value, "y", 0, 10, 0.1);
  }
}
