﻿/**
 * 複数メッシュを使ったスライダークラス
 * Slider class using multiple meshes
 */
import { Ob } from "negl";
import { IUniform } from "three";

/**
 * スライド番号
 * Slide number
 */
export type SlideIdx = number;

/**
 * スライド切り替えアニメーション関数
 * SingleMeshSlider と ParticleSlider で使用しています。
 * Slide transition animation function
 * Used in SingleMeshSlider and ParticleSlider.
 */
export type SlideTransitionFn = (
  uProgress: IUniform,
  onStart: () => void,
  onComplete: () => void
) => void;
/**
 * スライダ基底クラス
 * MultiMeshSlider、SingleSlider、ParticleSlider の基底クラスです。
 * Base slider class
 * It is the base class for MultiMeshSlider, SingleSlider, and ParticleSlider.
 */
class Slider extends Ob {
  /**
   * 選択されたスライド番号を保持します。
   * Holds the selected slide number.
   */
  activeSlideIdx: SlideIdx = 0;
  /**
   * スライド切り替え中の場合、true。それ以外、false。
   * true if the slide is switching, otherwise false.
   */
  running: boolean = false;
  /**
   * 再生中の動画を保持します。
   * Holds the video that is currently playing.
   */
  playingVideo: HTMLVideoElement | null = null;
  /**
   * 指定された idx にスライダを切り替えます。
   * Switches the slider to the specified idx.
   * @param idx
   */
  goTo(idx: number): void {}

  /**
   * idx をスライド枚数の範囲内の数値で返却します。
   * Returns the idx as a number within the range of slide counts.
   * @param idx
   * @returns
   */
  getModIdx(idx: SlideIdx): number {
    return ((idx % this.texes.size) + this.texes.size) % this.texes.size;
  }
}

export { Slider };
