import { Vector2 } from "three";
import vertexShader from "./vertex.glsl";
import fragmentShader from "./fragment.glsl";
import { SingleMeshSlider } from "#/parts/helper/slider/SingleMeshSlider";
export default class extends SingleMeshSlider {
  setupUniforms() {
    const uniforms = super.setupUniforms();
    uniforms.uNoiseScale = { value: new Vector2(2, 2) };
    return uniforms;
  }

  setupVertex() {
    return vertexShader;
  }

  setupFragment() {
    return fragmentShader;
  }

  debug(folder) {
    super.debug(folder);

    folder.add(this.uniforms.uNoiseScale.value, "x", 0, 10, 0.1);
    folder.add(this.uniforms.uNoiseScale.value, "y", 0, 10, 0.1);
  }
}
