import { Vector3 } from "three";
import { ParticleSlider } from "#/parts/helper/slider/ParticleSlider";
import vertexShader from "./vertex.glsl";
import fragmentShader from "./fragment.glsl";
export default class extends ParticleSlider {
  setupUniforms() {
    const uniforms = super.setupUniforms();
    uniforms.uPointSize = { value: 5 };
    uniforms.uSpeed = { value: 0.05 };
    uniforms.uCnoise = { value: new Vector3(0.005, 0, 0.01) };
    uniforms.uExpand = { value: new Vector3(0.1, 0.1, 0.1) };
    return uniforms;
  }

  setupVertex() {
    return vertexShader;
  }

  setupFragment() {
    return fragmentShader;
  }

  debug(folder) {
    super.debug(folder);

    folder
      .add(this.uniforms.uSpeed, "value", 0, 0.1, 0.001)
      .name("uSpeed")
      .listen();
    folder
      .add(this.uniforms.uPointSize, "value", 2, 10, 0.1)
      .name("uPointSize")
      .listen();
    folder
      .add(this.uniforms.uCnoise.value, "x", 0, 0.01, 0.001)
      .name("cnoise.x")
      .listen();
    folder
      .add(this.uniforms.uCnoise.value, "y", 0, 0.01, 0.001)
      .name("cnoise.y")
      .listen();
    folder
      .add(this.uniforms.uCnoise.value, "z", 0, 0.01, 0.001)
      .name("cnoise.z")
      .listen();

    folder
      .add(this.uniforms.uExpand.value, "x", 0, 10, 0.01)
      .name("expand.x")
      .listen();
    folder
      .add(this.uniforms.uExpand.value, "y", 0, 10, 0.01)
      .name("expand.y")
      .listen();
    folder
      .add(this.uniforms.uExpand.value, "z", 0, 10, 0.01)
      .name("expand.z")
      .listen();

    folder.add(this.uniforms.uAlpha, "value", 0, 1, 0.1).name("alpha").listen();
  }
}
