import { PlaneGeometry, Vector3, Float32BufferAttribute } from "three";
import vertexShader from "./vertex.glsl";
import fragmentShader from "./fragment.glsl";
import { utils } from "negl";
import { ParticleSlider } from "#/parts/helper/slider/ParticleSlider";
export default class extends ParticleSlider {
  setupGeometry() {
    const width = this.rect.width,
      height = this.rect.height,
      wSeg = Math.floor(width / this.pointInterval),
      hSeg = Math.floor(height / this.pointInterval);

    const plane = new PlaneGeometry(width, height, wSeg, hSeg);

    // 対角線上に詰められた遅延時間用の頂点データ
    // Vertex data for latency packed along the diagonal.
    const intensityVertices = utils.getDiagonalVertices(
      hSeg,
      wSeg,
      () => random(0, 1500),
      0
    );

    function random(a, b) {
      return a + (b - a) * Math.random();
    }

    plane.setAttribute(
      "aIntensity",
      new Float32BufferAttribute(intensityVertices, 1)
    );

    return plane;
  }

  setupUniforms() {
    const uniforms = super.setupUniforms();
    uniforms.uPointSize = { value: 5 };
    uniforms.uSpeed = { value: 0.05 };
    uniforms.uCnoise = { value: new Vector3(0.005, 0, 0.01) };
    uniforms.uExpand = { value: new Vector3(1, 1, 1) };
    return uniforms;
  }

  setupVertex() {
    return vertexShader;
  }

  setupFragment() {
    return fragmentShader;
  }

  debug(folder) {
    super.debug(folder);

    folder
      .add(this.uniforms.uSpeed, "value", 0, 0.1, 0.001)
      .name("uSpeed")
      .listen();

    folder
      .add(this.uniforms.uPointSize, "value", 2, 10, 0.1)
      .name("uPointSize")
      .listen();

    folder
      .add(this.uniforms.uCnoise.value, "x", 0, 0.01, 0.001)
      .name("cnoise.x")
      .listen();
    folder
      .add(this.uniforms.uCnoise.value, "y", 0, 0.01, 0.001)
      .name("cnoise.y")
      .listen();
    folder
      .add(this.uniforms.uCnoise.value, "z", 0, 0.01, 0.001)
      .name("cnoise.z")
      .listen();

    folder
      .add(this.uniforms.uExpand.value, "x", 0, 10, 0.1)
      .name("expand.x")
      .listen();
    folder
      .add(this.uniforms.uExpand.value, "y", 0, 10, 0.1)
      .name("expand.y")
      .listen();
    folder
      .add(this.uniforms.uExpand.value, "z", 0, 10, 0.1)
      .name("expand.z")
      .listen();
  }
}
