varying vec2 vUv;
uniform sampler2D tDiffuse;
uniform float uTick;
uniform float uProgress;
uniform vec4 uParam;
uniform float uScale;
uniform float uAlpha;

float rand(vec2 co) {
  return fract(sin(dot(co.xy, vec2(12.9898, 78.233))) * 43758.5453);
}

void main() {
  vec2 uv = vUv;

  vec2 p = 2.0 * uv - vec2(1.);
  p += 0.2 * sin(uTick / 80.) * cos(uParam.x * p.yx + (1. - uProgress) + vec2(2., 3.));
  p -= 0.2 * cos(uTick / 80.) * cos(uParam.y * p.yx + (1. - uProgress) * 1.5 + vec2(0.6, 5.2));
  p += 0.2 * sin(uTick / 80.) * cos(uParam.z * p.yx + (1. - uProgress) * 2.6 + vec2(3.1, 2.4));
  p += 0.2 * cos(uParam.w * p.yx + (1. - uProgress) * 3.8 + vec2(5.4, 1.4));

  uv.x = mix(uv.x, length(p), (1. - uProgress));
  uv.y = mix(uv.y, (1. - length(p)) * uScale, (1. - uProgress));

  vec4 t1 = texture(tDiffuse, uv);
  vec4 color = vec4(t1.rgb, t1.a * uAlpha);
  gl_FragColor = color;
  // gl_FragColor *= uAlpha;
}
