import gsap from "gsap";
import { Ob } from "negl";
import vertexShader from "./vertex.glsl";
import fragmentShader from "./fragment.glsl";
import { Vector4 } from "three";

export default class extends Ob {
  setupTexes(uniforms) {
    this.texes.forEach((tex, key) => {
      uniforms["tDiffuse"] = { value: tex };
    });
    return uniforms;
  }
  setupUniforms() {
    const uniforms = super.setupUniforms();
    uniforms.uSpeed = { value: 7.1 };
    uniforms.uParam = { value: new Vector4(1, 1, 1, 1) };
    uniforms.uScale = { value: 1 };
    uniforms.uRand = { value: Math.random() };
    return uniforms;
  }
  setupVertex() {
    return vertexShader;
  }
  setupFragment() {
    return fragmentShader;
  }
}
